package com.pingan.frame.util;

import com.pingan.frame.util.jzlib.JZlib;
import com.pingan.frame.util.jzlib.ZStream;


public class JZlibUtil {
    private static final String TAG = JZlibUtil.class.getSimpleName();

    /**
     * 压缩
     * 
     * @param data
     * @param type 压缩方法为一个整数 -1为默认压缩比 9为最高压缩比 0为不压缩 1为快速压缩
     * @param len
     * @return
     * @throws Exception
     */
    public static byte[] compressfile(byte[] data, int type, int len) throws Exception {

        int err;
        int comprLen = len;
        byte[] compr = new byte[comprLen];
        ZStream c_stream = new ZStream();
        err = c_stream.deflateInit(type);

        CHECK_ERR(c_stream, err, "deflateInit");

        c_stream.next_in = data;
        c_stream.next_in_index = 0;

        c_stream.next_out = compr;
        c_stream.next_out_index = 0;

        while (c_stream.total_in != data.length && c_stream.total_out < comprLen) {
            c_stream.avail_in = c_stream.avail_out = 1; // 置初值
            err = c_stream.deflate(JZlib.Z_NO_FLUSH);
            CHECK_ERR(c_stream, err, "deflate");
        }

        int i = 0;
        while (true) {
            i++;
            c_stream.avail_out = 1;
            err = c_stream.deflate(JZlib.Z_FINISH);
            if (err == JZlib.Z_STREAM_END) {
                break;
            }

            CHECK_ERR(c_stream, err, "deflate");

        }

        err = c_stream.deflateEnd();

        CHECK_ERR(c_stream, err, "deflateEnd");

        byte[] zipfile = new byte[(int) c_stream.total_out];
        System.arraycopy(compr, 0, zipfile, 0, zipfile.length);
        return zipfile;
    }

    /**
     * 解压缩
     * 
     * @param data
     * @param len
     * @return
     * @throws Exception
     */
    public static byte[] uncompressfile(byte[] data, int len) throws Exception {
        int err;
        int uncomprLen = len;
        byte[] uncompr = new byte[uncomprLen];
        ZStream d_stream = new ZStream();

        err = d_stream.inflateInit();
        CHECK_ERR(d_stream, err, "inflateInit");

        d_stream.next_in = data;
        d_stream.next_in_index = 0;
        d_stream.next_out = uncompr;
        d_stream.next_out_index = 0;

        while (d_stream.total_out < uncomprLen && d_stream.total_in < uncomprLen) {
            d_stream.avail_in = d_stream.avail_out = 1;
            err = d_stream.inflate(JZlib.Z_NO_FLUSH);
            if (err == JZlib.Z_STREAM_END) {
                break;
            }
            CHECK_ERR(d_stream, err, "inflate");
        }

        err = d_stream.inflateEnd();
        CHECK_ERR(d_stream, err, "inflateEnd");

        byte[] unzipfile = new byte[(int) d_stream.total_out];
        System.arraycopy(uncompr, 0, unzipfile, 0, unzipfile.length);
        return unzipfile;
    }

    static boolean CHECK_ERR(ZStream z, int err, String msg) throws Exception {
        if (err != JZlib.Z_OK) {
            if (z.msg != null) {
                // System.out.println("&&&&&&&&&&&&&&&&&&&  msg  &&&&&&&&&&&&&&&&&&&&&&&&");
                // System.out.print(z.msg + "   qqqq");
            }
            throw new Exception("解压失败uncompressfile is error  err = " + err);
        }
        return false;
    }

}
