package com.pingan.frame.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import org.apache.http.message.BasicHeader;

import com.pingan.frame.http.HttpThread;
import com.pingan.frame.http.upload.HttpUploadRequest;

public class MultipartEntity {
	
	private final String mBoundary;
	private long mContentLength = -1;
	private long writed = 0;
	private StringBuffer mData = new StringBuffer();
	private ArrayList<FileInfo> mFiles = new ArrayList<FileInfo>();
	private String mContentType;
	private HttpUploadRequest mHttpUploadRequest;

	private final String FILE_TPL =  "--%s\r\nContent-Disposition: form-data;name=\"%s\";filename=\"%s\"\r\nContent-Type: %s\r\n\r\n";
	public MultipartEntity(HttpUploadRequest uploadRequest){
		this.mHttpUploadRequest = uploadRequest;
		this.mBoundary = getRandomString(32);
		this.mContentType = "multipart/form-data; boundary=" + mBoundary;
	}
	
	public void addField(String key, String value) {
		String tmp = "--%s\r\nContent-Disposition: form-data; name=\"%s\"\r\n\r\n%s\r\n";
		mData.append(String.format(tmp, mBoundary, key, value));
	}

	public void addFile(String field, String contentType, String fileName, InputStreamAt isa) {
		mFiles.add(new FileInfo(field, contentType, fileName, isa));
	}
	
	private String getRandomString(int length) {
		String base = "abcdefghijklmnopqrstuvwxyz0123456789";
		Random random = new Random();
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < length; i++) {
			int number = random.nextInt(base.length());
			sb.append(base.charAt(number));
		}
		return sb.toString();
	}
	
	public long getContentLength() {
		if (mContentLength > 0) return mContentLength;
		long len = mData.toString().getBytes().length;
		for (FileInfo fi: mFiles) {
			len += fi.length();
		}
		len += 6 + mBoundary.length();
		mContentLength = len;
		return len;
	}
	
	public void writeTo(OutputStream outputStream) throws Exception {
		outputStream.write(mData.toString().getBytes());
		outputStream.flush();
		writed += mData.toString().getBytes().length;
		if (mHttpUploadRequest != null) 
			HttpThread.postUploadProgress(mHttpUploadRequest, writed, getContentLength());
		for (FileInfo i: mFiles) {
			i.writeTo(outputStream);
		}
		byte[] data = ("--" + mBoundary + "--\r\n").getBytes();
		outputStream.write(data);
		outputStream.flush();
		writed += data.length;
		if (mHttpUploadRequest != null) 
			HttpThread.postUploadProgress(mHttpUploadRequest, writed, getContentLength());
		outputStream.close();
	}
	
	class FileInfo {

		public String mField = "";
		public String mContentType = "";
		public String mFilename = "";
		public InputStreamAt mIsa;

		public FileInfo(String field, String contentType, String filename, InputStreamAt isa) {
			mField = field;
			mContentType = contentType;
			mFilename = filename;
			mIsa = isa;
			if (mContentType == null || mContentType.length() == 0) {
				mContentType = "application/octet-stream";
			}
		}
		
		public long length() {
			return FILE_TPL.length() - 2*4 + mBoundary.length() + mIsa.length() + 2 +
				mField.getBytes().length + mContentType.length() + mFilename.getBytes().length;
		}

		public void writeTo(OutputStream outputStream) throws Exception {
			byte[] data = String.format(FILE_TPL, mBoundary, mField, mFilename, mContentType).getBytes();
			outputStream.write(data);
			outputStream.flush();
			writed += data.length;
			if (mHttpUploadRequest != null) 
				HttpThread.postUploadProgress(mHttpUploadRequest, writed, getContentLength());

			int blockSize = (int) (getContentLength() / 100);
			if (blockSize > 256 * 1024) blockSize = 256 * 1024;
			if (blockSize < 16 * 1024) blockSize = 16 * 1024;
			long index = 0;
			long length = mIsa.length();
			while (index < length) {
				int readLength = (int) StrictMath.min((long) blockSize, mIsa.length() - index);
				outputStream.write(mIsa.read(index, readLength));
				index += blockSize;
				outputStream.flush();
				writed += readLength;
				if (mHttpUploadRequest != null) 
					HttpThread.postUploadProgress(mHttpUploadRequest, writed, getContentLength());
			}
			outputStream.write("\r\n".getBytes());
			outputStream.flush();
			writed += 2;
			if (mHttpUploadRequest != null) 
				HttpThread.postUploadProgress(mHttpUploadRequest, writed, getContentLength());
			mIsa.close();
		}
	}
	
	public String getContentType() {
		return mContentType;
	}
}
