package com.pingan.frame.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CUNGUANTONG
 * @date 2011-12-14
 * @version
 * @description 系统自定义Map类
 */
@SuppressWarnings("unchecked")
public class PAHashMap<K, V> extends HashMap<K, V> implements Map<K, V> {

	public static final String KEY_ATTRIBUTES = "attributesPA";
	public static final String KEY_TEXT = "textPA";
	
	private static final long serialVersionUID = -814238145128956406L;

	static final String TAG = PAHashMap.class.getSimpleName();

	PAHashMap<Object, Object> map;

	public PAHashMap() {

	}

	/**
	 * 根据key值把Map中的list Map转换成List 要获取的LIST元素路径
	 * 例如：要得到debitCardList中Element数组，传入key值为responseBody/debitCardList，
	 * 传入elmentName为Element
	 * 
	 * @param key
	 *            List元素所在的路径
	 * @param elementName
	 *            list元素名称
	 * @param map
	 *            查询数据源
	 * @return
	 */
	public List<PAHashMap<String, Object>> getListByKey(String key,
			String elementName) {
		List<PAHashMap<String, Object>> lists = new ArrayList<PAHashMap<String, Object>>();
		Object obj = getObjectByKey(key);
		if ("".equals(obj) || obj == null) {
			return null;
		}
		try {
			PAHashMap<String, Object> maps = (PAHashMap<String, Object>) obj;
			int length = maps.size();
			PAHashMap<String, Object> tmpMap = null;
			if (length > 0) {

				tmpMap = (PAHashMap<String, Object>) maps.get(elementName);
				if (tmpMap != null)
					lists.add(tmpMap);

				for (int i = 1; i < length; ++i) {
					tmpMap = null;
					tmpMap = (PAHashMap<String, Object>) maps.get(elementName
							+ i);
					if (tmpMap != null) {
						lists.add(tmpMap);
					}
				}
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}

		return lists;
	}

	/**
	 * 根据Element取Map中的list 传入elmentName为Element
	 * 
	 * @param key
	 *            List元素所在的路径
	 * @param elementName
	 *            list元素名称
	 * @param map
	 *            查询数据源
	 * @return
	 */
	/**
	 * [根据Element取Map中的list]<BR>
	 * [功能详细描述]
	 * 
	 * @param maps
	 *            传入的map
	 * @param elementName
	 *            为Element
	 * @return
	 */
	public List<Map<String, String>> getListByKey(
			PAHashMap<String, Object> maps, String elementName) {
		List<Map<String, String>> lists = new ArrayList<Map<String, String>>();
		if (maps == null) {
			return null;
		}
		try {
			int length = maps.size();
			Map<String, String> tmpMap = null;
			if (length > 0) {

				tmpMap = (Map<String, String>) maps.get(elementName);
				if (tmpMap != null)
					lists.add(tmpMap);

				for (int i = 1; i < length; ++i) {
					tmpMap = null;
					tmpMap = (Map<String, String>) maps.get(elementName + i);
					lists.add(tmpMap);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}


		return lists;
	}

	/**
	 * 根据key值得到字符串，如为空则返回""
	 * 
	 * @param key
	 * @param map
	 * @return
	 */
	public String getStringBykey(String key) {
		Object object = getObjectByKey(key);
		if(object instanceof PAHashMap){
			PAHashMap hashMapItem = (PAHashMap) object;
			if(hashMapItem.containsKey(PAHashMap.KEY_TEXT)){
				return hashMapItem.getStringBykey(PAHashMap.KEY_TEXT);
			}else{
				return "";
			}
		}
		else if (object != null && !"null".equals(object.toString()))
			return object.toString();
		else
			return "";
	}

	/**
	 * 根据key值得到object对象
	 * 
	 * @param key
	 * @param map
	 * @return object对象，或为Map<String,object>或者是string、int等基本类型
	 */

	public Object getObjectByKey(String key) {
		try {
			String[] keys = key.split("/");
			for (int i = 0; i < keys.length - 1 && !this.isEmpty(); ++i) {
				if ("".equals(keys[i]))
					continue;
				if (map == null)
					map = (PAHashMap<Object, Object>) get(keys[i]);
				else
					map = (PAHashMap<Object, Object>) map.get(keys[i]);
			}
			key = keys[keys.length - 1];
			if (map != null)
				return map.get(key);
			else {
				return get(key);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		} finally {
			map = null;
		}

	}

}
