package com.pingan.frame.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;

/**
 * 工具处理类
 * 
 * @date 2013-4-19
 */
public class Tools {

	public static final String TAG = Tools.class.getSimpleName();

	/**
	 * [得到key]<BR>
	 * [功能详细描述]
	 * @param keys
	 * @return
	 */
	public static String getKey(String... keys)
	{
		if(keys == null) return "";
		StringBuffer sbKey = new StringBuffer();
		
		for(int i=0;i<keys.length;i++)
		{
			sbKey.append(keys[i]);
			if(i == keys.length -1)
			{
				break;
			}
			sbKey.append(File.separator);
		}
		return sbKey.toString();
	}
	
	public static boolean isEmpty(String str){
		if(str==null||"".equals(str.trim())||"null".equals(str.trim())){
			return true;
		}
		return false;
	}

	/**
	 * 判断网络是否畅通
	 * 
	 * @param context
	 * @return
	 */
	public static boolean isNetworkAvailable(Context context) {
		ConnectivityManager connectivity = (ConnectivityManager) context
				.getSystemService(Context.CONNECTIVITY_SERVICE);
		if (connectivity == null) {
			return false;
		} else {
			NetworkInfo[] info = connectivity.getAllNetworkInfo();
			if (info != null) {
				for (int i = 0; i < info.length; i++) {
					if (info[i].getState() == NetworkInfo.State.CONNECTED) {
						return true;
					}
				}
			}
		}
		return false;
	}

	/**
	 * 判断是否有SD卡
	 * 
	 * @return
	 */
	public static boolean avaiableSDCard() {
		String status = Environment.getExternalStorageState();
		if (status.equals(Environment.MEDIA_MOUNTED)) {
			return true;
		} else {
			return false;
		}
	}

	public static String inputStream2String(InputStream is) throws IOException {
		BufferedReader reader = new BufferedReader(new InputStreamReader(is));    

		StringBuilder sb = new StringBuilder();    
		String line = null;    
		try {    

		    while ((line = reader.readLine()) != null) {    

		        sb.append(line);    

		    }    
		} catch (IOException e) {    
			e.printStackTrace();    
			throw e;
		} finally {                   
		    try {                   
		        is.close();                   
		    } catch (IOException e) {           
		        e.printStackTrace();            
		    }                   
		}                   
		return sb.toString();
	}
	
	public static byte[] inputStream2ByteArrary(InputStream is) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		byte[] bytes = new byte[1024];
		int length = 0;
		while((length = is.read(bytes))>0){
			baos.write(bytes, 0, length);
		}
		return baos.toByteArray();
	}
	
	/**
     * 加密session key
     * @param friendSession
     * @return
     */
    public static String buildSessionKey(String friendSession){
        if (friendSession==null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(friendSession);
        String fMsg = friendSession + sb.reverse();
        
        while (fMsg.length()<24*2) {
            fMsg += fMsg;
        }
        
        StringBuilder fsb = new StringBuilder();
        for (int i = 0; i < 48; i+=2) {
            fsb.append(fMsg.charAt(i));
        }
        return fsb.toString();
    }
	
	public static boolean equals(Object ob1,Object ob2){
    	if(ob1==null){
    		if(ob1 == ob2){
    			return true;
    		}
    	}else{
    		if(ob1.equals(ob2)){
    			return true;
    		}
    	}
    	return false;
    }

}
