package im.zego.zegoexpress.constants;

/** Audio capture source type. */
public enum ZegoAudioSourceType {
    /** Default audio capture source (the main channel uses custom audio capture by default; the aux channel uses the same sound as main channel by default) */
    DEFAULT(0),
    /** Use custom audio capture, refer to [enableCustomAudioIO] */
    CUSTOM(1),
    /** Use media player as audio source, only support aux channel */
    MEDIA_PLAYER(2);

    private int value;

    private ZegoAudioSourceType(int value) { this.value = value; }

    public int value() { return this.value; }

    public static ZegoAudioSourceType getZegoAudioSourceType(int value) {
        try {

            if (DEFAULT.value == value) {
                return DEFAULT;
            }

            if (CUSTOM.value == value) {
                return CUSTOM;
            }

            if (MEDIA_PLAYER.value == value) {
                return MEDIA_PLAYER;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}