package im.zego.zegoexpress.constants;

/** The music resource type. */
public enum ZegoCopyrightedMusicType {
    /** Song. */
    ZEGO_COPYRIGHTED_MUSIC_SONG(0),
    /** Song with high quality. */
    ZEGO_COPYRIGHTED_MUSIC_SONG_HQ(1),
    /** Song with super quality. */
    ZEGO_COPYRIGHTED_MUSIC_SONG_SQ(2),
    /** Song accompaniment. */
    ZEGO_COPYRIGHTED_MUSIC_ACCOMPANIMENT(3),
    /** Song accompaniment clip. */
    ZEGO_COPYRIGHTED_MUSIC_ACCOMPANIMENT_CLIP(4);

    private int value;

    private ZegoCopyrightedMusicType(int value) { this.value = value; }

    public int value() { return this.value; }

    public static ZegoCopyrightedMusicType getZegoCopyrightedMusicType(int value) {
        try {

            if (ZEGO_COPYRIGHTED_MUSIC_SONG.value == value) {
                return ZEGO_COPYRIGHTED_MUSIC_SONG;
            }

            if (ZEGO_COPYRIGHTED_MUSIC_SONG_HQ.value == value) {
                return ZEGO_COPYRIGHTED_MUSIC_SONG_HQ;
            }

            if (ZEGO_COPYRIGHTED_MUSIC_SONG_SQ.value == value) {
                return ZEGO_COPYRIGHTED_MUSIC_SONG_SQ;
            }

            if (ZEGO_COPYRIGHTED_MUSIC_ACCOMPANIMENT.value == value) {
                return ZEGO_COPYRIGHTED_MUSIC_ACCOMPANIMENT;
            }

            if (ZEGO_COPYRIGHTED_MUSIC_ACCOMPANIMENT_CLIP.value == value) {
                return ZEGO_COPYRIGHTED_MUSIC_ACCOMPANIMENT_CLIP;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}