package im.zego.zegoexpress.entity;

import android.app.Application;
import android.graphics.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.internal.*;
import java.nio.*;
import java.util.*;
import org.json.*;

/**
 * Mix stream video config object.
 *
 * Configure video frame rate, bitrate, and resolution for mixer task
 */
public class ZegoMixerVideoConfig {

    /** Video resolution width */
    public int width;

    /** Video resolution height */
    public int height;

    /** Video FPS, cannot be modified after starting a mixer task */
    public int fps;

    /** Video bitrate in kbps */
    public int bitrate;

    public ZegoMixerVideoConfig() {
        this.width = 360;
        this.height = 640;
        this.fps = 15;
        this.bitrate = 600;
    }

    public ZegoMixerVideoConfig(int width, int height, int fps, int bitrate) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitrate = bitrate;
    }
}
