package im.zego.zegoexpress.callback;

import android.app.Application;
import android.graphics.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.internal.*;
import java.nio.*;
import java.util.*;
import org.json.*;

public abstract class IZegoCustomVideoRenderHandler {

    /**
     * When custom video rendering is enabled, the original video frame data collected by the local preview is called back.
     *
     * Available since: 1.1.0
     * Description: When using custom video rendering, the SDK callbacks the original video frame data collected by the local preview, which is rendered by the developer.
     * Use cases: Use a cross-platform interface framework or game engine; need to obtain the video frame data collected or streamed by the SDK for special processing.
     * When to Trigger: When the local preview is turned on, when the SDK collects the local preview video frame data.
     * Related APIs: Call [setCustomVideoRenderHandler] to set custom video rendering callback.
     *
     * @param data Raw video frame data (eg: RGBA only needs to consider data[0], I420 needs to consider data[0,1,2]).
     * @param dataLength Data length (eg: RGBA only needs to consider dataLength[0], I420 needs to consider dataLength[0,1,2]).
     * @param param Video frame parameters.
     * @param flipMode video flip mode.
     * @param channel Publishing stream channel.
     */
    public void onCapturedVideoFrameRawData(ByteBuffer[] data, int[] dataLength,
                                            ZegoVideoFrameParam param, ZegoVideoFlipMode flipMode,
                                            ZegoPublishChannel channel) {}

    /**
     * When custom video rendering is enabled, the remote end pulls the original video frame data to call back, and distinguishes different streams by streamID.
     *
     * Available since: 1.1.0
     * Description: When custom video rendering is enabled, the SDK calls back the remote end to pull the original video frame data, distinguishes different streams by streamID, and renders them by the developer.
     * Use cases: Use a cross-platform interface framework or game engine; need to obtain the video frame data collected or streamed by the SDK for special processing.
     * When to Trigger: After starting to stream, when the SDK receives the video frame data of the remote stream.
     * Related APIs: Call [setCustomVideoRenderHandler] to set custom video rendering callback.
     *
     * @param data Raw video frame data (eg: RGBA only needs to consider data[0], I420 needs to consider data[0,1,2]).
     * @param dataLength Data length (eg: RGBA only needs to consider dataLength[0], I420 needs to consider dataLength[0,1,2]).
     * @param param Video frame parameters.
     * @param streamID Stream ID.
     */
    public void onRemoteVideoFrameRawData(ByteBuffer[] data, int[] dataLength,
                                          ZegoVideoFrameParam param, String streamID) {}

    /**
     * The callback for obtianing the video frames (Encoded Data) of the remote stream. Different streams can be identified by streamID.
     *
     * Available since: 1.1.0
     * Description: When custom video rendering is enabled, the remote end pulls the video frame encoded data callback, distinguishes different streams by streamID, and renders by the developer.
     * Use cases: Scenes where a cross-platform interface framework or game engine is used, or the video frame data collected or streamed by the SDK needs to be obtained for special processing.
     * When to Trigger: After starting to stream, the SDK receives the video frame data of the remote stream.
     * Related APIs: Call [setCustomVideoRenderHandler] to set custom video rendering callback.
     *
     * @param data Encoded data of video frames.
     * @param dataLength Data length.
     * @param param Video frame parameters.
     * @param referenceTimeMillisecond video frame reference time, UNIX timestamp, in milliseconds.
     * @param streamID Stream ID.
     */
    public void onRemoteVideoFrameEncodedData(ByteBuffer data, int dataLength,
                                              ZegoVideoEncodedFrameParam param,
                                              long referenceTimeMillisecond, String streamID) {}
}
