package im.zego.zegoexpress.entity;

import android.app.Application;
import android.graphics.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.internal.*;
import java.nio.*;
import java.util.*;
import org.json.*;

/**
 * Mixer input.
 *
 * Configure the mix stream input stream ID, type, and the layout
 */
public class ZegoMixerInput {

    /** Stream ID, a string of up to 256 characters. Caution: You cannot include URL keywords, otherwise publishing stream and playing stream will fails. Only support numbers, English characters and '~', '!', '@', '$', '%', '^', '&', '*', '(', ')', '_', '+', '=', '-', '`', ';', '’', ',', '.', '<', '>', '/', '\'.If you need to communicate with the Web SDK, please do not use '%'. If you need to communicate with the Mini Program SDK, due to the limitations of the Mini Program, the streamID of the zego-pusher and zego-player components only supports numbers, English characters and '_', '-'. If these two components are used, the streamID's naming rules should be aligned with the Mini Program SDK. */
    public String streamID;

    /** Mix stream content type */
    public ZegoMixerInputContentType contentType;

    /** Stream layout. When the mixed stream is an audio stream (that is, the ContentType parameter is set to the audio mixed stream type), the layout field is not processed inside the SDK, and there is no need to pay attention to this parameter. */
    public Rect layout;

    /** If enable soundLevel in mix stream task, an unique soundLevelID is need for every stream */
    public int soundLevelID;

    /** Input stream volume, valid range [0, 200], default is 100 */
    public int volume;

    /** Whether the focus voice is enabled in the current input stream, the sound of this stream will be highlighted if enabled */
    public boolean isAudioFocus;

    /** The direction of the audio. Valid direction is between 0 to 360. Set -1 means disable. Default value is -1 */
    public int audioDirection;

    /** Text watermark. */
    public ZegoLabelInfo label;

    /** Video view render mode. */
    public ZegoMixRenderMode renderMode;

    /** User image information. */
    public ZegoMixerImageInfo imageInfo;

    /** Video frame corner radius, in px. Required: False. Value range: Does not exceed the width and height of the video screen set by the [layout] parameter. Default value: 0. */
    public int cornerRadius;

    public ZegoMixerInput(String streamID, ZegoMixerInputContentType contentType, Rect layout) {
        this.streamID = streamID;
        this.contentType = contentType;
        this.layout = layout;
        this.soundLevelID = 0;
        this.volume = 100;
        this.isAudioFocus = false;
        this.audioDirection = -1;
        this.label = new ZegoLabelInfo("");
        this.renderMode = ZegoMixRenderMode.FILL;
        this.imageInfo = new ZegoMixerImageInfo("");
        this.cornerRadius = 0;
    }

    public ZegoMixerInput(String streamID, ZegoMixerInputContentType contentType, Rect layout,
                          int soundLevelID) {
        this.streamID = streamID;
        this.contentType = contentType;
        this.layout = layout;
        this.soundLevelID = soundLevelID;
        this.volume = 100;
        this.isAudioFocus = false;
        this.audioDirection = -1;
        this.label = new ZegoLabelInfo("");
        this.renderMode = ZegoMixRenderMode.FILL;
        this.imageInfo = new ZegoMixerImageInfo("");
        this.cornerRadius = 0;
    }

    public ZegoMixerInput(String streamID, ZegoMixerInputContentType contentType, Rect layout,
                          int soundLevelID, boolean isAudioFocus, int audioDirection) {
        this.streamID = streamID;
        this.contentType = contentType;
        this.layout = layout;
        this.soundLevelID = soundLevelID;
        this.volume = 100;
        this.isAudioFocus = isAudioFocus;
        this.audioDirection = audioDirection;
        this.label = new ZegoLabelInfo("");
        this.renderMode = ZegoMixRenderMode.FILL;
        this.imageInfo = new ZegoMixerImageInfo("");
        this.cornerRadius = 0;
    }
}
