package im.zego.zegoexpress.entity;

import android.app.Application;
import android.graphics.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.internal.*;
import java.nio.*;
import java.util.*;
import org.json.*;

/**
 * Advanced player configuration.
 *
 * Configure playing stream CDN configuration, video layer, room id.
 */
public class ZegoPlayerConfig {

    /** Stream resource mode. */
    public ZegoStreamResourceMode resourceMode = ZegoStreamResourceMode.DEFAULT;

    /** The CDN configuration for playing stream. If set, the stream is play according to the URL instead of the streamID. After that, the streamID is only used as the ID of SDK internal callback. */
    public ZegoCDNConfig cdnConfig;

    /** @deprecated This property has been deprecated since version 1.19.0, please use the [setPlayStreamVideoLayer] function instead. */
    @Deprecated public ZegoPlayerVideoLayer videoLayer = ZegoPlayerVideoLayer.AUTO;

    /** The Room ID. */
    public String roomID;

    /** The video encoding type of the stream. */
    public ZegoVideoCodecID videoCodecID = ZegoVideoCodecID.UNKNOWN;

    /** The resource type of the source stream. */
    public ZegoResourceType sourceResourceType = ZegoResourceType.RTC;

    /** Preconfigured codec template ID */
    public int codecTemplateID;
}
