package im.zego.zegoexpress.entity;

import android.app.Application;
import android.graphics.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.internal.*;
import java.nio.*;
import java.util.*;
import org.json.*;

/**
 * Voice changer parameter.
 *
 * Developer can use the built-in presets of the SDK to change the parameters of the voice changer.
 */
public class ZegoVoiceChangerParam {

    /** Pitch parameter, value range [-12.0, 12.0], the larger the value, the sharper the sound, set it to 0.0 to turn off. Note the tone-shifting sound effect is only effective for the sound played by the media player, and does not change the tone collected by the microphone. Note that on v2.18.0 and older version, the value range is [-8.0, 8.0]. */
    public float pitch;

    /**
     * Create voice changer param configuration with preset enumeration values
     *
     * @deprecated This function is deprecated after 1.17.0 Please use the ZegoExpressEngine's [setVoiceChangerPreset] function instead
     */
    @Deprecated
    public ZegoVoiceChangerParam(ZegoVoiceChangerPreset preset) {
        if (preset == ZegoVoiceChangerPreset.NONE) {
            this.pitch = 0.0f;
        } else if (preset == ZegoVoiceChangerPreset.MEN_TO_CHILD) {
            this.pitch = 8.0f;
        } else if (preset == ZegoVoiceChangerPreset.MEN_TO_WOMEN) {
            this.pitch = 4.0f;
        } else if (preset == ZegoVoiceChangerPreset.WOMEN_TO_CHILD) {
            this.pitch = 6.0f;
        } else if (preset == ZegoVoiceChangerPreset.WOMEN_TO_MEN) {
            this.pitch = -3.0f;
        } else if (preset == null) {
            this.pitch = 0.0f;
        }
    }

    public ZegoVoiceChangerParam() { this.pitch = 0.0f; }
}
