/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

var utils = require('cordova/utils');
var exec = require('cordova/exec');

/**
 * Heplers
 */

function noop(){}

var ajaxconfig = {
    //发送方法
    type: "GET",
    //成功回调
    success: noop,
    //失败回调
    error: noop,
    //完成后的回调
    complete: noop,
    //默认参数
    data: {},
    //超时
    timeout: 0
};
/**
 * Ajax 请求对象
 * @constructor
 */
function Ajax() {

}

Ajax.prototype.ajax = function (options) {
    var suc = noop,
        err = noop;
    if (typeof options == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        options = arguments[2];
    }
    var config = options || {};

    var isSupportDeferred = window.$ && window.$.Deferred;
    var deferred, promise;
    if (isSupportDeferred) {
        deferred = $.Deferred && $.Deferred();
        promise = {};
    }

    for (var key in ajaxconfig) {
        if (config[key] === undefined) {
            config[key] = ajaxconfig[key];
        }
    }
    options.url = utils.completeUrl(options.url);
    if (isSupportDeferred) {
        deferred.promise(promise).complete = noop;
    }

    exec(function (result) {
        var status = 'success';
        var xhr = null;

        if (isSupportDeferred) {
            deferred.resolve(result,status,xhr);
        }
        typeof config.success == 'function' && config.success(result,status,xhr);
        //hdp调用，传了回调promise
        suc(result, status, xhr);
        typeof config.complete == 'function' && config.complete(xhr,status);
    }, function (error) {
        var status = 'error';
        var xhr = null;
        var _result = error;

        error = {
            status : {
                code : error.code,
                msg : error.msg
            }
        };

        if (isSupportDeferred) {
            deferred.reject(xhr,status,error);
        }
        typeof config.error == 'function' && config.error(xhr,status,error);
        //hdp调用，传了回调promise
        err(xhr, status, error);
        typeof config.complete == 'function' && config.complete(xhr,status);
    }, "CDVAjax", "ajax", [{type: config.type, url: config.url, data: config.data}]);

    return promise;
}

//原生请求
Ajax.prototype.ajaxOrigin = function (options) {
    var suc = noop,
        err = noop;
    if (typeof options == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        options = arguments[2];
    }
    var config = options || {};

    var isSupportDeferred = window.$ && window.$.Deferred;
    var deferred, promise;
    if (isSupportDeferred) {
        deferred = $.Deferred && $.Deferred();
        promise = {};
    }

    for (var key in this.ajaxconfig) {
        if (config[key] === undefined) {
            config[key] = this.ajaxconfig[key];
        }
    }
    options.url = utils.completeUrl(options.url);

    if (isSupportDeferred) {
        deferred.promise(promise).complete = noop;
    }

    exec(function (result) {
        var status = 'success';
        var xhr = null;

        if (isSupportDeferred) {
            deferred.resolve(result,status,xhr);
        }
        typeof config.success == 'function' && config.success(result,status,xhr);
        //hdp调用，传了回调promise
        suc(result, status, xhr);
        typeof config.complete == 'function' && config.complete(xhr,status);
    }, function (error) {
        var status = 'error';
        var xhr = null;
        if (isSupportDeferred) {
            deferred.reject(xhr,status,error);
        }
        typeof config.error == 'function' && config.error(xhr,status,error);
        //hdp调用，传了回调promise
        err(xhr, status, error);
        typeof config.complete == 'function' && config.complete(xhr,status);
    }, "CDVAjax", "ajaxOrigin", [{type: config.type, url: config.url, data: config.data, userAgent: config.userAgent, referer: config.referer}]);
    return promise;
}

// mwp
Ajax.prototype.mwp = function(success, error, name, version, params, method, isHttp) {
    success = success || function() {};
    error = error || function() {};
    params = params || {};

    if (typeof method !== 'string') {
        method = "get";
    } else {
        method = method.toLocaleLowerCase();
        if (method !== 'post' && method !== 'get') {
            method = 'get';
        }
    }

    if (isHttp == null) {
        isHttp = true;
    } else {
        if (typeof isHttp !== 'boolean') {
            isHttp = true;
        }
    }

    exec(success, error, "CDVAjax", "mwp", [name, version, params, method, isHttp]);
}

if(window.mgj){
    if(mgj.mwpEnable === false){
        Ajax.prototype.mwp = function(){};
    }else{
        window.mgj.mwpEnable = true;
    }
}else{
    window.mgj = {mwpEnable:true};
}

module.exports = new Ajax();