/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */


var argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');

//channel.createSticky('onCordovaInfoReady');
// Tell cordova channel to wait on the CordovaInfoReady event
//channel.waitForInitialization('onCordovaDeviceInfoReady');

/**
 * This represents the mobile device, and provides properties for inspecting the model, version, UUID of the
 * phone, etc.
 * @constructor
 * typedef NS_ENUM(NSInteger, AFNetworkReachabilityStatus) {
    AFNetworkReachabilityStatusUnknown          = -1,
    AFNetworkReachabilityStatusNotReachable     = 0,
    AFNetworkReachabilityStatusReachableViaWWAN = 1,
    AFNetworkReachabilityStatusReachableViaWiFi = 2,
};
 */
function Device() {
    this.available = false;
    this.platform = null;
    this.version = null;
    this.appVersion = null;
    this.deviceID = null;
    this.screenWidh = null;
    this.screenHeight = null;
    this.navHeight = null;
    this.cordova = null;
    this.model = null;
    this.navigationBarHeight = null;
    this.statusBarHeight = null;

    var me = this;

    //channel.onCordovaReady.subscribe(function () {
    this.getInfo(function (info) {
        //ignoring info.cordova returning from native, we should use value from cordova.version defined in cordova.js
        //TODO: CB-5105 native implementations should not return info.cordova
        var buildLabel = cordova.version;
        me.available = true;
        me.platform = info.platform;
        me.version = info.version;
        me.deviceID = info.deviceID;
        me.networkType = info.networkType;
        me.screenHeight = info.screenHeight;
        me.screenWidh = info.screenWidh;
        me.navHeight = info.navHeight;
        me.cordova = buildLabel;
        me.model = info.model;
        me.navigationBarHeight = info.navigationBarHeight;
        me.statusBarHeight = info.statusBarHeight;
        //channel.onCordovaDeviceInfoReady.fire();
    }, function (e) {
        me.available = false;
        //channel.onCordovaDeviceInfoReady.fire();
        //utils.alert("[ERROR] Error initializing Cordova: " + e);
    });
    //});
}

var _noop = function() {};
/**
 * Get device info
 *
 * @param {Function} successCallback The function to call when the heading data is available
 * @param {Function} errorCallback The function to call when there is an error getting the heading data. (OPTIONAL)
 */
Device.prototype.getInfo = function (successCallback, errorCallback) {
    argscheck.checkArgs('fF', 'Device.getInfo', arguments);
    exec(successCallback, errorCallback, "CDVDevice", "getDeviceInfo", []);
};

Device.prototype.getInfoObject = function (successCallback, errorCallback) {
    argscheck.checkArgs('fF', 'Device.getInfoObject', arguments);
    exec(successCallback, errorCallback, "CDVDevice", "getDeviceInfoObject", []);
};

Device.prototype.signParams = function (params, successCallback, errorCallback) {
    var suc = _noop,
        err = _noop;
    if (typeof params == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        params = arguments[2];
    } else {
        suc = successCallback;
        err = errorCallback;
    }
    exec(suc, err, "CDVDevice", "signParams", [params]);
};

module.exports = new Device();