/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

var exec = require('cordova/exec');
var noop = function(){};


/**
 * 蘑菇街图片操作插件
 *
 * @constructor
 */
function image() {
}
/**
 * 上传多张图片
 * @param successCallback 成功回调
 * @param failCallback 失败回调
 * @param aspectRatio 需要截取图片的比例
 */
image.prototype.imageUploadMultiple = function (successCallback, failCallback, quality) {
	if(typeof quality !== 'number'){
		quality = 80;
	}

	if (arguments.length > 3) {
	    fixedWidth = arguments[3]
	    exec(successCallback, failCallback, "CDVImage", 'imageUploadMultiple', [quality, fixedWidth]);
	} else {
    	exec(successCallback, failCallback, "CDVImage", 'imageUploadMultiple', [quality]);
	}
};

/**
 * 上传图片
 * @param successCallback 成功回调
 * @param failCallback 失败回调
 * @param aspectRatio 需要截取图片的比例
 */
image.prototype.imageUpdate = function (successCallback, failCallback, aspectRatio, quality) {
	if (typeof aspectRatio === 'undefined') {
		aspectRatio = null;
	}
	if(typeof quality !== 'number'){
		quality = 80;
	}

	if (arguments.length > 4) {
	    fixedWidth = arguments[4]
	    exec(successCallback, failCallback, "CDVImage", 'imageUpdate', [aspectRatio, quality, fixedWidth]);
	} else {
    	exec(successCallback, failCallback, "CDVImage", 'imageUpdate', [aspectRatio, quality]);
	}
};

image.prototype.addWebviewLongPressSave = function (successCallback, failCallback) {
	exec(successCallback, failCallback, "CDVImage", 'addWebviewLongPressSave', []);
};

image.prototype.removeWebviewLongPressSave = function (successCallback, failCallback) {
	exec(successCallback, failCallback, "CDVImage", 'removeWebviewLongPressSave', []);
};

image.prototype.selfSnapShot = function (successCallback, failCallback, aspectRatio, quality) {
	if (typeof aspectRatio === 'undefined') {
		aspectRatio = null;
	}
	if(typeof quality !== 'number'){
		quality = 80;
	}
	exec(successCallback, failCallback, "CDVImage", 'selfSnapShot', [aspectRatio, quality]);
};
image.prototype.takeScreenshot = function (success, fail) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVImage', 'takeScreenshot', [])
};
// 保存图片
image.prototype.saveImage = function (success, fail, imageUrl) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVImage', 'saveImage', [imageUrl])
};


module.exports = new image();
