/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

var exec = require('cordova/exec');

/**
 * 蘑菇街图片操作插件
 * @constructor
 */
function location() {
}

var _noop = function() {};
/**
 * 上传图片
 * @param successCallback 成功回调
 * @param failCallback 失败回调
 */
location.prototype.pickLocationInfo = function (successCallback, province, city, area) {
	var suc = _noop,
        err = _noop;
    if (typeof province == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        province = arguments[2];
        city = arguments[3];
        area = arguments[4];
    } else {
        suc = successCallback;
    }
    province = province || '';
    city = city || '';
    area = area || '';
    exec(suc, err, "CDVLocation", 'pickLocationInfo', [province, city, area]);
};

/**
 * 获取定位信息
 * @param successCallback 成功回调
 * @param failCallback 失败回调
 */
location.prototype.getLocationInfo = function (successCallback,errorCallback) {
    exec(successCallback , errorCallback , "CDVLocation", 'getLocationInfo', []);
};

module.exports = new location();
