/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

var argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');

/**
 * 注册通知事件
 * @constructor
 */
function GlobalNotification() {
    var me = this;
}
var _noop = function() {};
/**
 * 发送
 * @param notificationName
 * @param params
 */
GlobalNotification.prototype.sendNotification = function (notificationName, params) {
	var suc = _noop,
		err = _noop;
    if (typeof notificationName == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        notificationName = arguments[2];
        params = arguments[3];
    }
    argscheck.checkArgs('S', 'GlobalNotification.sendNotification', notificationName);
    exec(suc, err, 'CDVMGJGlobalNotification', 'sendNotification', [notificationName, params])
};

/**
 * 注册通知，当本地收到通知后会触发document上面事件名称为notificationName的事件，同时有可能传递一个对象给这个事件
 * @param notificationName
 */
GlobalNotification.prototype.registerNotification = function (notificationName) {
	var suc = _noop,
		err = _noop;
    if (typeof notificationName == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        notificationName = arguments[2];
    }
    argscheck.checkArgs('S', 'GlobalNotification.registerNotification', notificationName);
    exec(suc, err, 'CDVMGJGlobalNotification', 'registerNotification', [notificationName])
};

/**
 * 解除全局通知
 */
GlobalNotification.prototype.removeNotification = function (notificationName) {
	var suc = _noop,
		err = _noop;
    if (typeof notificationName == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        notificationName = arguments[2];
    }
    argscheck.checkArgs('S', 'GlobalNotification.removeNotification', notificationName);
    exec(suc, err, 'CDVMGJGlobalNotification', 'removeNotification', [notificationName]);
};

module.exports = new GlobalNotification();
