/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

var exec = require('cordova/exec');
var argscheck= require('cordova/argscheck');

/**
 * Navigation class
 * @constructor
 */
function Navigation() {
}

var service = "CDVNavigation";

Navigation.prototype.StatusBarStyle = {
    Default: 0,
    Light: 1,
    Hidden: 2
};

var _noop = function() {};
/**
 * 控制导航栏右边按钮
 * @type {{setTitle: setTitle, setIcon: setIcon}}
 */
Navigation.prototype.rightitem = {
    setTitle: function(title, color) {
        var suc = _noop,
            err = _noop;
        if (typeof title == 'function') {
            //hdp调用，传了回调
            suc = arguments[0];
            err = arguments[1];
            title = arguments[2];
            color = arguments[3];
        }
        title = title || '';
        Navigation.prototype.rightItemTitle = title;
        exec(suc, err, "CDVNavigation", "setRightTitle", [title, color]);
    },
    setIcon: function(icon) {
        var suc = _noop,
            err = _noop;
        if (typeof icon == 'function') {
            //hdp调用，传了回调
            suc = arguments[0];
            err = arguments[1];
            icon = arguments[2];
        }
        icon = icon || '';
        Navigation.prototype.rightItemIcon = icon;
        exec(suc, err, "CDVNavigation", "setRightIcon", [icon]);
    }
};

/**
 * 控制导航栏左侧按钮
 * @type {{setTitle: setTitle, setIcon: setIcon}}
 */
Navigation.prototype.leftitem = {
    setTitle: function(title, color) {
        var suc = _noop,
            err = _noop;
        if (typeof title == 'function') {
            //hdp调用，传了回调
            suc = arguments[0];
            err = arguments[1];
            title = arguments[2];
            color = arguments[3];
        }
        title = title || '';
        Navigation.prototype.leftItemTitle = title;
        exec(suc, err, "CDVNavigation", "setLeftTitle", [title, color]);
    },
    setIcon: function(icon) {
        var suc = _noop,
            err = _noop;
        if (typeof icon == 'function') {
            //hdp调用，传了回调
            suc = arguments[0];
            err = arguments[1];
            icon = arguments[2];
        }
        icon = icon || '';
        Navigation.prototype.leftItemIcon = icon;
        exec(suc, err, "CDVNavigation", "setLeftIcon", [icon]);
    }
};

/**
 * 设置导航栏中间标题
 * @param title
 */
Navigation.prototype.setTitle = function(title, color) {
    var suc = _noop,
        err = _noop;
    if (typeof title == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        title = arguments[2];
        color = arguments[3];
    }
    title = title || '';
    exec(suc, err, "CDVNavigation", "setCenterItemTitle", [title, color]);
};
/**
 * 将一个新的页面推入视图栈
 * @param path
 */
Navigation.prototype.pushWindow = function (path, isAnimated) {
    var suc = _noop,
        err = _noop;
    if (typeof path == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        path = arguments[2];
        isAnimated = arguments[3];
    }
    isAnimated = argscheck.getValue(isAnimated, true);
    exec(suc, err, "CDVNavigation", "pushWindow", [path, isAnimated]);
};

/**
 * 将当前页面弹出试图栈
 * @param msg
 */
Navigation.prototype.popWindow = function (msg) {
    var suc = _noop,
        err = _noop;
    if (typeof msg == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        msg = arguments[2];
    }
    exec(suc, err, "CDVNavigation", "popWindow", [msg || 1]);
};

 /**
  * 实现一个Native的replace方法 (Tabbar用，不提供给前端)
  * @param msg
  */
Navigation.prototype.replace = function (msg) {
    var suc = _noop,
    err = _noop;
    if (typeof msg == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        msg = arguments[2];
    }
    exec(suc, err, "CDVNavigation", "replace", [msg || '']);
};

/**
 * 返回到根root
 * @param msg
 */
Navigation.prototype.popToRoot = function (msg) {
    var suc = _noop,
        err = _noop;
    if (typeof msg == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        msg = arguments[2];
    }
    exec(suc, err, "CDVNavigation", "popToRoot", []);
};

/**
 * 设置navgtaionbar背景
 */
Navigation.prototype.setNavgationBackground = function (color, alpha) {
    var suc = _noop,
        err = _noop;
    if (typeof color == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        color = arguments[2];
        alpha = arguments[3];
    }
    alpha = (typeof alpha == 'number' && alpha >= 0) ? (Math.round(alpha * 10) / 10) : 1; //取1位小数即可
    exec(suc, err, "CDVNavigation", "setBackground", [color, alpha]);
}

/**
 * 设置statusbar的样式 （深、浅）
 * IOS Only
 */
Navigation.prototype.setStatusBarLight = function (flag) {
    var suc = _noop,
        err = _noop;
    if (typeof flag == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        flag = arguments[2];
    }
    flag = flag || 0;

    if (typeof flag != 'number' || flag < 0 || flag > 2) {
        flag = 0;
    }

    exec(suc, err, "CDVNavigation", "setStatusBarLight", [flag]);
}

/**
 * 设置下拉框功能
 */
Navigation.prototype.setDropMenu = function (items) {
    var suc = _noop,
        err = _noop;
    if (typeof items == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        items = arguments[2];
    }

    if (items != null) {
        exec(suc, err, "CDVNavigation", "setDropMenu", [items]);
    }

}

/**
 * 设置下拉框功能items
 * items -->> [{key:'key1', title:'title1'}, {key:'key2', title:'title2'}]
 */

Navigation.prototype.setDropMenuItems = function (suc, err, items) {
    var action = 'setDropMenuItems';

    argscheck.checkArgs('FFA', (service + '.' + action), arguments);

    exec(suc, err, service, action, [items]);

}

Navigation.prototype.showDropMenu = function () {
    var suc = _noop,
        err = _noop;
    if (typeof items == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
    }

    exec(suc, err, "CDVNavigation", "showDropMenu", []);

}

/**
 * 设置右上角多个btn
 * name:事件名称
 * type:icon类型
 * value:传入的值
 * color:颜色
 */
Navigation.prototype.setNavigationBarRightIcons = function(items) {
    var iconList;
    var suc = _noop,
        err = _noop;
    if (typeof items == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        iconList = arguments[2];
    }else{
        iconList = items;
    }

    if(!iconList || !iconList.length){
        return ;
    }

    var filterList = [];
    for(var i = 0, len = iconList.length; i < len; i ++) {
        var configItem = iconList[i];
        if (typeof configItem == 'object' && configItem['name'] && configItem['type'] && configItem['value']) {
            filterList.push(configItem);
        }
    }

    exec(suc, err, "CDVNavigation", "setNavigationBarRightIcons", [filterList]);
}

/**
 * 显示购物车图标，有高亮和不高亮的区分
 */
Navigation.prototype.showCart = function(successCallback, failCallback) {
    exec(successCallback || _noop, failCallback || _noop, "CDVNavigation", "showCart", []);
}

Navigation.prototype.addNew4Cart= function(successCallback, failCallback) {
    exec(successCallback || _noop, failCallback || _noop, "CDVNavigation", "addNew4Cart", []);
}

/*
 * 显示小房子
 */
Navigation.prototype.showBackHomeButton = function(successCallback, failCallback) {
    exec(successCallback || _noop, failCallback || _noop, "CDVNavigation", "showBackHomeButton", []);
}

/*
* 返回按钮拦截
*/
Navigation.prototype.interceptClose = function(status) {
    var suc = _noop,
        err = _noop;
    if (typeof status == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        status = arguments[2];
    }
    status = (status || status === undefined) ? 1 : 0;
    exec(suc, err, "CDVNavigation", "interceptClose", [status]);
};

/**
* 导航tab， 参数tabStr为tab的json string描述
*/
Navigation.prototype.showNavigationTab = function (tabStr) {
    var suc = _noop,
        err = _noop;
    if (typeof tabStr == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        tabStr = arguments[2];
    }
    tabStr = tabStr || '';
    exec(suc, err, "CDVNavigation", "showNavigationTab", [tabStr]);
}

Navigation.prototype.setLeftCustomIcon = function (icon) {
    var suc = _noop,
        err = _noop;
    if (typeof icon == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        icon = arguments[2];
    }
    icon = icon || '';
    exec(suc, err, "CDVNavigation", "setLeftCustomIcon", [icon]);
}

/*
* 全屏模式
*/
Navigation.prototype.setFullScreen = function(status) {
    var suc = _noop,
        err = _noop;
    if (typeof status == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        status = arguments[2];
    }
    status = (status || status === undefined) ? 1 : 0;
    exec(suc, err, "CDVNavigation", "setFullScreen", [status]);
}

module.exports = new Navigation();
