/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/

var exec = require('cordova/exec');
var noop = function(){};

function PopUp () {

}

PopUp.prototype.show = function (success, fail) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVPopUp', 'show', [])
}
PopUp.prototype.close = function (success, fail) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVPopUp', 'close', [])
}
PopUp.prototype.opaue = function (success, fail, opaueType, modalThreshold) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVPopUp', 'opaue', [opaueType, modalThreshold])
}
PopUp.prototype.pageArea = function (success, fail, x1, y1, x2, y2) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVPopUp', 'pageArea', [x1, y1, x2, y2])
}
PopUp.prototype.open = function (success, fail, tagId, params) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVPopUp', 'open', [tagId, params])
}

module.exports = new PopUp();
