/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

var exec = require('cordova/exec');

function Security() {

}

/**
 * @param successCallback 成功回调
 * @param failCallback 失败回调
 * @param strContent 需要加密的内容
 * @param from 加密源
 */
Security.prototype.sign= function (successCallback, failCallback, strContent, from) {
    if (typeof strContent != 'string' || typeof from != 'number') {
        return ;
    }
    exec(successCallback, failCallback, "CDVSecurity", 'sign', [strContent, from]);
}

Security.prototype.install = function (successCallback, failCallback, verifyId, from) {
    if (typeof verifyId != 'string' || typeof from != 'number') {
        return;
    }
    exec(successCallback, failCallback, "CDVSecurity", 'install', [from, verifyId]);
}

module.exports = new Security();
