/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

var argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');


/**
 * Share class
 *
 * @constructor
 */
function Share() {
    //channel.onOneMgjIsReady.fire();
}

/**
 *
 * @param successCallback
 * @param failCallback
 * @param args 参数，参数内容如下
 * title 分享标题
 * url 分享地址，若为空则为www.mogujie.com
 * imageUrl 分享图片地址
 * content 分享文本
 * type 分享类型，默认为pop,共有如下几种类型
 *    * pop 默认分享方式，弹出分享对话框让用户选择
 *    * qq 分享给qq好友
 *    * weixinFriend 分享给微信好友
 *    * qzone 分享给qzone
 *    * weixinFriendQuan 分享到好友圈
 *    * sinaWB 分享到新浪微博
 * isWechatCircleImage 微信朋友圈分享的是图片
 */
Share.prototype.shareItem = function (successCallback, failCallback, args) {
    var getValue = argscheck.getValue;
    //0
    var title = getValue(args.title, "");
    //1
    var url = getValue(args.url, "");
    //2
    var imageUrl = getValue(args.imageUrl, "");
    //3
    var content = getValue(args.content, "");
    //4
    var type = getValue(args.type, "pop");
    //5
    var needCallback = args.needCallback ? 1 : 0;
    //6
    var shareArray = getValue(args.shareArray, []);
    //7
    var wechatCircleImageUrl = getValue(args.wechatCircleImageUrl, "");
    //8
    var miniProgramPath = getValue(args.miniProgramPath,"");
    //9
    var miniProgramAppId = getValue(args.miniProgramAppId, "");

    exec(successCallback, failCallback, "CDVShare", "shareItem", [title, content, url, imageUrl, type, needCallback, shareArray, wechatCircleImageUrl, miniProgramPath, miniProgramAppId]);
};

module.exports = new Share();
