/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

var exec = require('cordova/exec');

function Storage() {
}

/**
 * 设置值
 * @param key
 * @param value
 */
Storage.prototype.setValueForKey = function (successCallback, failedCallback, key, value) {
    if (typeof key == 'undefined') {
        return;
    }
    exec(successCallback, failedCallback, 'CDVStorage', 'CDVSetValueForKey', [key, value]);
};

/**
 * 根据key获取value
 * @param key
 * @param callback
 * @param isSystem 是否从本地客户端数据库中获取数据
 */
Storage.prototype.valueForKey = function (successCallback, failedCallback, key, isSystem) {
    isSystem = typeof isSystem != 'undefined' ? isSystem : false;

    if (typeof key == 'undefined') {
        callback(undefined);
        return;
    }

    exec(successCallback, failedCallback, 'CDVStorage', 'CDVGetValueForKey', [key, isSystem]);
};

/**
 * 根据key移除对应的键值
 * @param key
 */
Storage.prototype.removeValueForKey = function (successCallback, failedCallback, key) {
    if (typeof key == 'undefined') {
        return;
    }
    exec(successCallback, failedCallback, 'CDVStorage', 'CDVRemoveValueForKey', [key]);
};

/**
 * 设置值
 * @param key
 * @param value
 */
Storage.prototype.setNativeValueForKey = function (successCallback, failedCallback, key, value) {
    if (typeof key == 'undefined') {
        return;
    }
    exec(successCallback, failedCallback, 'CDVStorage', 'CDVSetNativeValueForKey', [key, value]);
};

/**
 * 根据key获取value
 * @param key
 * @param callback
 * @param isSystem 是否从本地客户端数据库中获取数据
 */
Storage.prototype.nativeValueForKey = function (successCallback, failedCallback, key, isSystem) {
    isSystem = typeof isSystem != 'undefined' ? isSystem : false;

    if (typeof key == 'undefined') {
        callback(undefined);
        return;
    }

    exec(successCallback, failedCallback, 'CDVStorage', 'CDVGetNativeValueForKey', [key, isSystem]);
};

/**
 * 根据key移除对应的键值
 * @param key
 */
Storage.prototype.removeNativeValueForKey = function (successCallback, failedCallback, key) {
    if (typeof key == 'undefined') {
        return;
    }
    exec(successCallback, failedCallback, 'CDVStorage', 'CDVRemoveNativeValueForKey', [key]);
};

module.exports = new Storage();