/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/
var argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');

function Tracker(){

}
var _noop = function(){};
/**
 * 发送打点事件
 * @param eventName 事件名称
 * @param eventParams 事件参数，字典
 */
Tracker.prototype.sendEvent = function (eventName, eventParams) {
	var suc = _noop,
		err = _noop;
    if (typeof eventName == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        eventName = arguments[2];
        eventParams = arguments[3];
    }
    var getValue = argscheck.getValue;
    eventName = getValue(eventName, "");
    eventParams = getValue(eventParams, {});
    exec(suc, err, "CDVTracker", 'sendEvent', [eventName, eventParams]);
};


/**
 * 发送打点自定义URL的P事件
 * @param url URL链接 http or https 开头的完整链接，字符串，必传
 * @param ptp_cnt PTP参数，字符串，必传
 * @param abtestList ABTest，数组，可选
 * @param force 是否强制上报，默认 false 时P事件只上报一次（如果同页面需要上报多个P事件，除第一个外其他需要true才会上报成功），布尔值，可选
 */
Tracker.prototype.sendPEvent = function (success, error, url, ptp_cnt, abtestList, force) {
    success = success || function() {};
    error = error || function() {};

    if (typeof abtestList === 'boolean') {
        // 三个参数的模式 url、ptp_cnt、force
        force = abtestList
        abtestList = []
    } else if (typeof abtestList === 'object' && abtestList instanceof Array) {
        if (typeof force !== 'boolean') {
            // 三个参数的模式 url、ptp_cnt、abtestList
            force = false
        }
        // else 四个参数的模式 url、ptp_cnt、abtestList、force
    } else {
        // 两个参数的模式 url、ptp_cnt
        force = false
        abtestList = []
    }

    exec(success, error, "CDVTracker", "trace", [url, ptp_cnt, abtestList, force]);
};


module.exports = new Tracker();
