/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

//cordova.define('plugins/user', function(require, argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');
var channel = require('cordova/channel');
var wrapper = require('cordova/parameterWrapper');

//channel.createSticky('onCordovaUserReady');
// Tell cordova channel to wait on the CordovaInfoReady event
//channel.waitForInitialization('onCordovaUserReady');

/**
 * Share class
 *
 * @constructor
 */
function User() {
    this.available = false;
    this.userInfo = {};
    var me = this;

    channel.onCordovaReady.subscribe(function () {
        //channel.onOneMgjIsReady.fire();
        //try to get user info when page load successfully
        me.getUserInfo(wrapper.secret, function (info) {
            if(typeof info == 'string'){
                info = JSON.parse(info).result;
            }
            me.userInfo = info;
            me.available = true;
            //channel.onCordovaUserReady.fire();
        }, function (error) {
            me.available = false;
            //channel.onCordovaUserReady.fire();
        }, []);
    });
}

User.prototype.refreshToken = function (successCallback) {
    exec(function () {
        if (successCallback) {
            successCallback();
        }
    }, null, "CDVUser", "refreshToken", [])
}

/**
 * call native login and return user info after login successfully
 * @param  function successCallback
 * @param  function failCallback
 * @param  Array    args
 * @return
 */
User.prototype.login = function (successCallback, failCallback, args) {
    args = args ? args : [];
    exec(function (userInfo) {//get userInfo if login successfully
        if (successCallback) {
            successCallback(userInfo);
        }
    }, failCallback, "CDVUser", "login", args);
};

User.prototype.logout = function (successCallback, failCallback, args) {
    var me = this;
    args = args ? args : [];
    exec(function () {
        me.available = false;
        me.userInfo = {};
        if (successCallback) {
            successCallback();
        }
    }, failCallback, "CDVUser", "logout", args);
};

User.prototype.showAuth = function (success, fail, args) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVUser', 'showAuth', [args])
};

User.prototype.jumpToJD = function (success, fail, args) {
    success = success || noop;
    fail = fail || noop;
    exec(success, fail, 'CDVUser', 'jumpToJD', [args])
};

User.prototype.getUserInfo = function (successCallback, failCallback, args) {
    args = args ? args : [];
    exec(successCallback, failCallback, "CDVUser", "getUserInfo", args);
};

User.prototype.refreshUserInfo = function () {
    var me = this;
    this.getUserInfo(function (info) {
        me.userInfo = info;
        me.available = true;
    }, function (error) {
        me.userInfo = null;
        me.available = false;
    }, []);
}

module.exports = new User();
//});
