/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */


var exec = require('cordova/exec');

function SmsExport() {}

var _noop = function() {};

SmsExport.prototype.send = function (phone, message, method, success, failure) {
    var suc = _noop,
        err = _noop;
    if (typeof phone == 'function') {
        //hdp调用，传了回调
        suc = arguments[0];
        err = arguments[1];
        phone = arguments[2];
        message = arguments[3];
        method = arguments[4];
    } else {
        suc = success;
        err = failure
    }
    phone = convertPhoneToArray(phone);

    exec(
        suc,
        err,
        'Sms',
        'send',
        [phone, message, method]
    );
};

module.exports = new SmsExport();

/**
 * Helpers
 */
function convertPhoneToArray(phone) {
    if (typeof phone === 'string' && phone.indexOf(',') !== -1) {
        phone = phone.split(',');
    }
    if (Object.prototype.toString.call(phone) !== '[object Array]') {
        phone = [phone];
    }
    return phone;
}