#version 300 es

precision mediump float;

uniform sampler2D u_texSrc;
uniform sampler2D u_texDst;
uniform float u_offsetY;
uniform float u_slideUpAlpha;
uniform float u_animateAlpha;

in highp vec2 v_texCoord0;

out vec4 fragColor;

const float ONE = 1.0;

float rand(vec2 c){
    return fract(sin(dot(c.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

void main()   {
    vec4 white = vec4(ONE);

    // 去除当前天气背景透明度
    vec3 colorSrc = texture(u_texSrc, vec2(v_texCoord0.x, v_texCoord0.y - u_offsetY)).rgb;
    // 去除下一天气背景透明度
    vec3 colorDst = texture(u_texDst, vec2(v_texCoord0.x, v_texCoord0.y - u_offsetY)).rgb;
    vec3 finalColor = mix(colorSrc, colorDst, ONE - u_animateAlpha);
    //    finalColor += mix(0.0, 0.004, rand(v_texCoord0));
    // 上滑1:1跟手，需要配合alpha透明度变化
    fragColor = vec4(finalColor, 1.0 * u_slideUpAlpha);
}