#version 300 es

precision highp float;

uniform vec4 u_startColor;
uniform vec4 u_endColor;

in highp vec2 v_texCoord0;

out vec4 fragColor;

float random (in vec2 st) {
    return fract(sin(dot(st.xy,vec2(12.9898,78.233)))
    * 43758.5453123);
}

void main(){
    vec4 outColor = (1.0 - v_texCoord0.y) * u_startColor + v_texCoord0.y * u_endColor;
    float noise = random(gl_FragCoord.xy * 1.667) + 0.03;
    noise -= 0.5;

    fragColor = outColor + noise / 245.0;
    fragColor.a = 1.0;
}