#version 300 es

precision highp float;

uniform float u_time;
uniform float u_aspect;

uniform float u_scale;
uniform float u_alpha;
uniform float u_speed;
uniform float u_amp_change_speed;
uniform float u_random_amp;
uniform float u_base_amp;
uniform float u_shift;

uniform float u_scale1;
uniform float u_alpha1;
uniform float u_speed1;
uniform float u_amp_change_speed1;
uniform float u_random_amp1;
uniform float u_base_amp1;
uniform float u_shift1;

in highp vec2 v_texCoord0;

out vec4 fragColor;

const float X_SCALE = 0.35/8.712;
const float Y_SCALE = 0.704;
const float MOVE_SPEED = 10.0;
const float CHANGE_SPEED = 4.0;

vec3 random3(vec3 c) {
    float j = 4096.0*sin(dot(c, vec3(17.0, 59.4, 15.0)));
    vec3 r;
    r.z = fract(512.0*j);
    j *= .125;
    r.x = fract(512.0*j);
    j *= .125;
    r.y = fract(512.0*j);
    return r - 0.5;
}

const float F3 = 0.3333333;
const float G3 = 0.1666667;


float map(float value, float oldMin, float oldMax, float newMin, float newMax) {
    return newMin + (newMax - newMin) * (value - oldMin) / (oldMax - oldMin);
}

vec4 permute(vec4 x) {
    return mod(((x * 34.0) + 1.0) * x, 289.0);
}

float simplex(vec3 v) {
    const vec2 C = vec2(1.0 / 6.0, 1.0 / 3.0);
    const vec4 D = vec4(0.0, 0.5, 1.0, 2.0);

    vec3 i = floor(v + dot(v, C.yyy));
    vec3 x0 = v - i + dot(i, C.xxx);

    vec3 g = step(x0.yzx, x0.xyz);
    vec3 l = 1.0 - g;
    vec3 i1 = min(g.xyz, l.zxy);
    vec3 i2 = max(g.xyz, l.zxy);

    vec3 x1 = x0 - i1 + C.xxx;
    vec3 x2 = x0 - i2 + C.yyy;
    vec3 x3 = x0 - D.yyy;

    i = mod(i, 289.0);
    vec4 p = permute(permute(permute(
             i.z + vec4(0.0, i1.z, i2.z, 1.0))
           + i.y + vec4(0.0, i1.y, i2.y, 1.0))
           + i.x + vec4(0.0, i1.x, i2.x, 1.0));

    float n_ = 0.142857142857;
    vec3 ns = n_ * D.wyz - D.xzx;

    vec4 j = p - 49.0 * floor(p * ns.z * ns.z);

    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - 7.0 * x_);

    vec4 x = x_ * ns.x + ns.yyyy;
    vec4 y = y_ * ns.x + ns.yyyy;
    vec4 h = 1.0 - abs(x) - abs(y);

    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);

    vec4 s0 = floor(b0) * 2.0 + 1.0;
    vec4 s1 = floor(b1) * 2.0 + 1.0;
    vec4 sh = -step(h, vec4(0.0));

    vec4 a0 = b0.xzyw + s0.xzyw * sh.xxyy;
    vec4 a1 = b1.xzyw + s1.xzyw * sh.zzww;

    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);

    vec4 norm = inversesqrt(vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3)));
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;

    vec4 m = max(0.6 - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), 0.0);
    m = m * m;
    return 42.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}


float snoiseFractal(vec3 m) {
    return 0.5333333 * simplex(m)
    + 0.2666667 * simplex(2.0*m)
    + 0.1333333 * simplex(4.0*m)
    + 0.0666667 * simplex(8.0*m);
}

float rand(vec2 c){
    return fract(sin(dot(c.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

float wave(){
    float amplitude = 1.;
    float frequency = 1.;
    float y = 0.;
    float t = 0.02*(-u_time*130.0);
    y += sin(t)*4.5;
    y += sin(t*1.121)*4.0;
    y += sin(t*0.437)*5.0;
    y += sin(t*4.269)*2.5;
    y *= amplitude*0.06;
    return y;
}

void main() {
    vec2 st = v_texCoord0;
    st.y /= u_aspect;

    float x = st.x;

    mediump float alpha;
    x -= u_time * 0.4 * u_amp_change_speed;
    st.y += sin(x*2.720 + u_shift)*(u_base_amp + sin(u_time) * u_random_amp);
    st.x *= X_SCALE;
    st.y *= (Y_SCALE * u_scale);
    st.x -= u_time * 0.04 * u_speed;
    alpha = snoiseFractal(vec3(st.x*3.0, st.y*3.0, 0.));
    alpha = pow(alpha, 2.0);
    alpha *= u_alpha;

    float y = v_texCoord0.y;
    if (y > 0.6){
        alpha *= (1.0 - y) * 2.5;
    }

    vec2 st1 = v_texCoord0;
    st1.y /= u_aspect;
    float x1 = st1.x;

    mediump float alpha1;
    x1 -= u_time * 0.4 * u_amp_change_speed1;
    st1.y += sin(x1*2.720 + u_shift1)*(u_base_amp1 + sin(u_time) * u_random_amp1);
    st1.x *= X_SCALE;
    st1.y *= (Y_SCALE * u_scale1);
    st1.x -= u_time * 0.04 * u_speed1;
    alpha1 = snoiseFractal(vec3(st1.x*3.0, st1.y*3.0, 0.));
    alpha1 = pow(alpha1, 2.0);
    alpha1 *= u_alpha1;

    float y1 = v_texCoord0.y;
    if (y1 > 0.6){
        alpha1 *= (1.0 - y) * 2.5;
    }

    fragColor = vec4(alpha, alpha1, 0.0, 0.0);
}