#version 300 es

precision mediump float;

uniform sampler2D u_tex0;
uniform sampler2D u_texDither;
uniform float u_strength;
uniform float u_alpha;

in highp vec2 v_texCoord0;

out vec4 fragColor;

void main() {
    float noise = texture(u_texDither, v_texCoord0 * vec2(16.875, 18.281)).r;

    float alpha = texture(u_tex0, v_texCoord0).r;
    alpha += (noise * 2.0 - 1.0) / 255.0;
    vec4 color = vec4(vec3(1.0), alpha * u_strength);

    float alpha1 = texture(u_tex0, v_texCoord0).g;
    alpha1 += (noise * 2.0 - 1.0) / 255.0;
    vec4 color1 = vec4(vec3(1.0), alpha1 * u_strength);

    fragColor = (color + color1) * 0.7;
    fragColor.a *= u_alpha;
}

