#version 310 es
#extension GL_EXT_gpu_shader5 : enable
precision highp float;

out vec4 outColor;
in float v_cos;
in float v_sin;
in float v_alpha;
in flat int v_texIndex;
in flat int v_noiseIndex;
uniform vec3 u_topColor;
uniform vec3 u_bottomColor;

uniform sampler2D cloudyMap;
uniform sampler2D noiseMap;
uniform float u_time;
uniform float u_timeFactor;

void main()
{
    float x = gl_PointCoord.x - 0.5;
    float y = gl_PointCoord.y - 0.5;
    float nx = (v_cos * x - v_sin * y);
    float ny = (v_sin * x + v_cos * y);
    vec2 newCoord = vec2(nx + 0.5, ny + 0.5);

    vec2 noiseCoord = gl_PointCoord.st + u_time * u_timeFactor;

    vec4 displace = texture(noiseMap, noiseCoord);
    float Y = displace[v_noiseIndex];
    float displace_k;
    displace_k = Y * 0.14;
    newCoord = newCoord.xy + displace_k;

    mediump float depth = gl_FragCoord.z / gl_FragCoord.w;
    mediump float fogFactor = smoothstep(0.0, -60.0, depth);

    vec3 fogColor = vec3(0.27059, 0.51765, 0.70588);

    if (newCoord.x > 1.0 || newCoord.x < 0.0 || newCoord.y > 1.0 || newCoord.y < 0.0) {
        discard;
    }
    outColor = texture(cloudyMap, newCoord);

    outColor.w = smoothstep(0.12, 1.0, outColor[v_texIndex]);
    outColor.rgb = vec3(1.0) + 0.1 * displace.rgb - vec3(0.05);
    outColor.w *= pow(gl_FragCoord.z, 20.0);
    outColor = mix(outColor, vec4(fogColor, outColor.w), fogFactor);

    outColor.a *= v_alpha;
    vec3 color1 = vec3(u_topColor.r, u_topColor.g, u_topColor.b);
    vec3 color2 = vec3(u_bottomColor.r, u_bottomColor.g, u_bottomColor.b);
    // mix bottom color
    //color2 = mix(color2, color1, Y);
    outColor.rgb = mix(color1, color2, smoothstep(0.3, 1.0, gl_PointCoord.y));

}
