#version 310 es
layout (location = 0) in vec4 position;
layout (location = 1) in vec4 attrib;

uniform mat4 u_projViewTrans;
uniform float u_pointSizeScale;

out float v_cos;
out float v_sin;
out float v_alpha;
out flat int v_texIndex;
out flat int v_noiseIndex;

void main()
{
    gl_PointSize = attrib.x / 2.5 * 0.85 * u_pointSizeScale;
    gl_Position =  u_projViewTrans * vec4(position.xyz, 1.0);

    v_cos = cos(attrib.y);
    v_sin = sin(attrib.y);
    v_alpha = attrib.w;
    v_texIndex = int(attrib.z);
    v_noiseIndex = int(position.w);
}