#version 300 es

precision mediump float;

uniform sampler2D u_tex0;
uniform vec2 u_resolution;

in vec2 v_texCoord0;

layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 fragDepth;

vec4 reSample(float d, vec2 uv) {
   vec4 fragColor = vec4(0.0);
    vec2 step1 = (vec2(d) + 0.5) / u_resolution.xy;
    fragColor += texture(u_tex0, uv + step1) / float(4);
    fragColor += texture(u_tex0,  uv - step1) / float(4);
     vec2 step2 = step1;
    step2.x = -step2.x;
    fragColor += texture(u_tex0, uv + step2) / float(4);
    fragColor += texture(u_tex0,  uv - step2) / float(4);
    return fragColor;
}

void main()	{
    vec2 uv = vec2(v_texCoord0.x, 1.-v_texCoord0.y);
    fragColor = reSample(0.3, uv);
}