#version 300 es

precision lowp float;

uniform sampler2D u_tex0;
uniform sampler2D u_tex1;
uniform float u_alpha;

in highp vec2 v_texCoord0;

out vec4 fragColor;

void main() {
    vec3 bg = texture(u_tex0, v_texCoord0).rgb;
    float alpha = texture(u_tex1, v_texCoord0).r;
    alpha = (1.0 - alpha) * (1.0 - alpha);

    vec3 color = 1.0 - alpha + alpha * bg;
    fragColor = vec4(color, u_alpha);
}