#version 300 es

precision mediump float;

uniform highp float u_ratio;
uniform float u_alpha;
uniform sampler2D u_texSrc;
uniform sampler2D u_texDst;
uniform sampler2D u_texDither;
uniform vec2 u_ditherScale;

in vec2 v_texCoord0;

out vec4 fragColor;

float rand(vec2 n) {
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

void main()	{
    vec3 colorSrc = texture(u_texSrc, v_texCoord0).rgb;
    vec3 colorDst = texture(u_texDst, v_texCoord0).rgb;

    vec3 finalColor = mix(colorSrc, colorDst, clamp(u_ratio, 0.0, 1.0));

    fragColor = vec4(finalColor, u_alpha);
}