#version 300 es

precision lowp float;

uniform sampler2D u_texDot;

in float v_blur;
in float v_alpha;

out vec4 fragColor;

float map(float value, float oldMin, float oldMax, float newMin, float newMax) {
    return newMin + (newMax - newMin) * (value - oldMin) / (oldMax - oldMin);
}

void main() {
    float blurX = distance(gl_PointCoord.xy, vec2(0.5, 0.5)) * 2.0;

    float alpha = texture(u_texDot, vec2(blurX, v_blur)).r;
    alpha *= v_alpha;

    fragColor = vec4(alpha, 1.0, 0.0, 0.0);
}