#version 300 es

in vec4 a_position;
in float a_depth;
in float a_size;
in float a_alpha;

const float BLUR_MIN = 0.4;
const float BLUR_MAX = 0.6;

uniform float u_pointSizeScale;

out float v_blur;
out float v_alpha;

void main() {
    float alpha = a_alpha;
    float y = a_position.y;
    if (y < -0.6){
        alpha *= (y + 1.0) * 2.5;
    }
    v_alpha = alpha;

    float blurRate = abs(a_depth - 0.5) * 2.0;
    v_blur = mix(BLUR_MIN, BLUR_MAX, blurRate);

    gl_Position = a_position;

    gl_PointSize = a_size * 0.5 * u_pointSizeScale;
}