#version 300 es
precision mediump float;
in vec2 v_texCoord0;
layout(location = 0) out vec4 outColor;
uniform sampler2D s_TextureMap;
uniform sampler2D s_BackgroundMap;
uniform sampler2D s_LUTMap;
uniform vec2 u_resolution;
uniform vec2 u_SunPos;
uniform int u_frame_id;
uniform float u_SunStrength;
uniform float u_alpha;

float remap(float x, float a, float b, float c, float d)
{
    return (((x - a) / (b - a)) * (d - c)) + c;
}

vec3 remap(vec3 x, float a, float b, float c, float d)
{
    return (((x - a) / (b - a)) * (d - c)) + c;
}

void main()
{
    float y = v_texCoord0.y * u_resolution.y / u_resolution.x;
    vec2 texCoord = vec2(v_texCoord0.x, y);    // texture coordinate

    vec4 cloud = vec4(0.0f);
    // use LUT for color and alpha correction
    vec4 cloud_gray  = texture(s_TextureMap, texCoord);
    vec2 lutcoord = vec2(0.0f);
    vec4 c_lut = vec4(0.0f);

    // case id even
    lutcoord = vec2(0.0f, cloud_gray.r * cloud_gray.g);
    c_lut = texture(s_LUTMap, lutcoord);
    cloud += float((u_frame_id+1)%2) * vec4(c_lut.r, c_lut.g, c_lut.b, cloud_gray.g);

    // case id odd
    lutcoord = vec2(0.0f, cloud_gray.b * cloud_gray.a);
    c_lut = texture(s_LUTMap, lutcoord);
    cloud += float(u_frame_id%2) * vec4(c_lut.r, c_lut.g, c_lut.b, cloud_gray.a);

    cloud.rgb = remap(cloud.rgb, 0.0, 1.0, 0.0, 0.95); // darken the color to lower power consumption

    float sunshine = 1.0f - length((u_SunPos - v_texCoord0) * u_resolution)/u_resolution.x;// places where have larger brightness
    sunshine = pow(sunshine, 5.0f);
    sunshine = remap(sunshine, 0.0f, 1.0f, 0.0f, 0.7f);

    vec4 ColorDst = texture(s_BackgroundMap, v_texCoord0); // background color

    outColor.rgb = (sign(y - 0.99f) * 1.0f + 1.0f) / 2.0f * ColorDst.rgb + // lower half, only bg color
    (sign(0.99f - y) * 1.0f + 1.0f) / 2.0f *
    (cloud.rgb + ColorDst.rgb * (1.0f - cloud.a) + cloud.a * sunshine * vec3(0.851f, 0.6862f, 0.5056f) * u_SunStrength); // upper half, cloud + bg

    outColor.a = u_alpha;
}
