#version 300 es
precision mediump float;
in vec2 v_texCoord0;
layout(location = 0) out vec4 outColor;
uniform sampler2D s_TextureMapR;
uniform sampler2D s_TextureMapG;
uniform sampler2D s_BackgroundMap;
uniform sampler2D s_LUTMap;
uniform float u_time;
uniform vec2 u_resolution;
uniform vec2 u_SunPos;
uniform int u_frame_id;
uniform float u_SunStrength;
uniform int NUM_ROW;
uniform int NUM_COL;
uniform int u_texWidth;
uniform int u_texHeight;
uniform float u_alpha;

float remap(float x, float a, float b, float c, float d)
{
    return (((x - a) / (b - a)) * (d - c)) + c;
}

void main()
{
    int im_id = u_frame_id % int(NUM_ROW*NUM_COL);
    int offset_x = im_id%NUM_COL;
    int offset_y = im_id/NUM_COL;

    float x = v_texCoord0.x;
    float y = v_texCoord0.y*u_resolution.y/u_resolution.x;


    vec4 cloud = vec4(0.0f);

    // pixel coordinate
    int pixel_x= offset_x*u_texWidth + int(x*float(u_texWidth))+1;
    int pixel_y= offset_y*u_texHeight + int(y*float(u_texHeight))+1; // REMOVES white line

    // texture coordinate
    vec2 texCoord = vec2(float(pixel_x)/float(NUM_ROW*u_texWidth),
    float(pixel_y)/float(NUM_COL*u_texHeight));

    // use LUT for color and alpha correction
    vec4 cloud_red  = texture(s_TextureMapR, texCoord);
    vec4 cloud_green  = texture(s_TextureMapG, texCoord);
        vec2 lutcoord = vec2(0.0f, cloud_red.a * cloud_green.a);
        vec4 c_lut = texture(s_LUTMap, lutcoord);
        cloud = vec4(c_lut.r, c_lut.g, c_lut.b, cloud_green.a);

    float sunshine = 1.0f - length((u_SunPos - v_texCoord0) * u_resolution)/u_resolution.x;// places where have larger brightness
    sunshine = pow(sunshine, 5.0f);
    sunshine = remap(sunshine, 0.0f, 1.0f, 0.0f, 0.7f);

    vec4 ColorDst = texture(s_BackgroundMap, v_texCoord0); // background color

    outColor.rgb = (sign(y - 0.99f) * 1.0f + 1.0f) / 2.0f * ColorDst.rgb + // lower half, only bg color
    (sign(0.99f - y) * 1.0f + 1.0f) / 2.0f *
    (cloud.rgb + ColorDst.rgb * (1.0f - cloud.a) + cloud.a * sunshine * vec3(0.851f, 0.6862f, 0.5056f) * 1.5f * u_SunStrength); // upper half, cloud + bg
    //outColor.rgb = outColor.rgb * u_alpha;
    //outColor.a = 1.0f;
    outColor.a = u_alpha;
}
