#version 300 es
precision mediump float;
in vec2 v_texCoord0;
layout(location = 0) out vec4 outColor;
uniform sampler2D s_TextureMap;
uniform sampler2D s_BackgroundMap;
uniform vec2 u_resolution;
uniform float u_alpha;
uniform float z_scaleX; // zoom scale factor
uniform float z_scaleY;
uniform float z_beginX; // zoom begin coordinate
uniform float z_beginY;
uniform float u_stretch;

void main()
{
    float x = v_texCoord0.x * z_scaleX + z_beginX;
    float y = v_texCoord0.y * u_resolution.y/u_resolution.x*u_stretch;
    y = y*z_scaleY + z_beginY;
    vec2 v_texCoord_cloud = vec2(x, y);

    vec4 cloud  = texture(s_TextureMap, v_texCoord_cloud);
    float lightning = cloud.b;
    cloud = vec4(cloud.r, cloud.r, cloud.r, cloud.g);

    vec4 ColorDst = texture(s_BackgroundMap, v_texCoord0);// background color
    outColor.rgb = cloud.rgb * cloud.a + ColorDst.rgb * (1.0f - cloud.a);
    outColor.a = u_alpha;
}