#version 300 es

precision mediump float;
uniform vec2 u_resolution;
uniform float u_alpha;
uniform float u_dpiScale;

uniform sampler2D u_texSun;
uniform sampler2D u_texCircle;
uniform sampler2D u_texHexagon1;
uniform sampler2D u_texHexagon2;
uniform sampler2D u_texRainbowA;
uniform sampler2D u_texRainbowB;

uniform vec2 u_sunWH;
uniform vec2 u_circleWH;
uniform vec2 u_hexagon1WH;
uniform vec2 u_hexagon2WH;
uniform vec2 u_rainbowAWH;
uniform vec2 u_rainbowBWH;

uniform vec2 u_sunPosition;
uniform vec2 u_circle1Position;
uniform vec2 u_circle2Position;
uniform vec2 u_circle3Position;
uniform vec2 u_circle4Position;
uniform vec2 u_circle5Position;
uniform vec2 u_rainbowAPosition;
uniform vec2 u_rainbowBPosition;

uniform float u_strength;
uniform float u_circle1StrengthAdd;
uniform float u_circle2StrengthAdd;
uniform float u_circle3StrengthAdd;
uniform float u_circle4StrengthAdd;
uniform float u_circle5StrengthAdd;
uniform float u_rainbowStrengthAdd;
uniform float u_isDarkMode;
uniform float u_particleScaleInverse;

uniform vec2 u_rainbowARotate;
uniform vec2 u_rainbowBRotate;

const vec3 CIRCLE_COLOR = vec3(0.25, 0.18, 0.4);

const float SUN_SIZE = 3.2;
const float CIRCLE_SIZE[5] = float[](1.25, 1.40, 1.1, 1.25, 1.35);
const float RAINBOW_SIZE[2] = float[](5.0, 1.3);

const float RAINBOW_STRENGTH[2] = float[](6.0, 150.0);

in vec2 v_texCoord0;
out vec4 fragColor;

vec2 scaleTragetTexcoor(vec2 st, vec2 center, vec2 resolution, vec2 targetWH) {
    return (st - center) * resolution * u_dpiScale / targetWH + 0.5;
}

vec2 rotate(vec2 st, vec2 rValue) {
    return vec2(st.x * rValue.x - st.y * rValue.y, st.x * rValue.y + st.y * rValue.x);
}

vec2 scaleAndRotateTexcoor(vec2 st, vec2 center, vec2 rotateValue, vec2 resolution, vec2 targetWH) {
    return rotate((st - center) * resolution * u_dpiScale / targetWH, rotateValue) + 0.5;
}

void main() {
    // sun
    vec2 sunTexCoor = scaleTragetTexcoor(v_texCoord0, u_sunPosition, u_resolution, u_sunWH * SUN_SIZE * u_strength);
    vec4 sunColor = texture(u_texSun, sunTexCoor);
    vec3 finalColor = sunColor.rgb * sunColor.a * 1.2;

    // circle1
    vec2 st = scaleTragetTexcoor(v_texCoord0, u_circle1Position, u_resolution, u_circleWH * CIRCLE_SIZE[0] * u_strength);
    vec4 color = texture(u_texCircle, st);
    finalColor += color.rgb * color.a * u_circle1StrengthAdd;

    // circle2
    st = scaleTragetTexcoor(v_texCoord0, u_circle2Position, u_resolution, u_circleWH * CIRCLE_SIZE[1] * u_strength);
    color = texture(u_texCircle, st);
    finalColor += color.rgb * color.a * u_circle2StrengthAdd;

    // circle3
    st = scaleTragetTexcoor(v_texCoord0, u_circle3Position, u_resolution, u_hexagon1WH * CIRCLE_SIZE[2] * u_strength);
    color = texture(u_texHexagon1, st);
    finalColor += color.rgb * color.a * u_circle3StrengthAdd;

    // circle4
    st = scaleTragetTexcoor(v_texCoord0, u_circle4Position, u_resolution, u_hexagon2WH * CIRCLE_SIZE[3] * u_strength);
    color = texture(u_texHexagon2, st);
    finalColor += color.rgb * color.a * u_circle4StrengthAdd;

    // circle5
    st = scaleTragetTexcoor(v_texCoord0, u_circle5Position, u_resolution, u_hexagon2WH * CIRCLE_SIZE[4] * u_strength);
    color = texture(u_texHexagon2, st);
    finalColor += color.rgb * color.a * u_circle5StrengthAdd;

    float sunRainbowDistance = distance(u_sunPosition, u_rainbowAPosition);
    // u_particleScaleInverse is used to increase alpha if rainbow in small size screen
    float rainbowAlpha = smoothstep(0.05, 0.35, sunRainbowDistance * u_particleScaleInverse);
    // rainbow Ahead
    st = scaleAndRotateTexcoor(v_texCoord0, u_rainbowAPosition, u_rainbowARotate,
                u_resolution, u_rainbowAWH * RAINBOW_SIZE[0] * u_strength);
    color = texture(u_texRainbowA, st);
    finalColor += color.rgb * color.a * rainbowAlpha * (RAINBOW_STRENGTH[0] + u_rainbowStrengthAdd * (1.0 - u_isDarkMode));

    // rainbow Behind
    st = scaleAndRotateTexcoor(v_texCoord0, u_rainbowBPosition, u_rainbowARotate,
                u_resolution, u_rainbowBWH * RAINBOW_SIZE[1] * u_strength);
    color = texture(u_texRainbowB, st);
    finalColor += color.rgb * color.a * rainbowAlpha
                * (RAINBOW_STRENGTH[1] + u_rainbowStrengthAdd * (1.0 - u_isDarkMode));

    fragColor = vec4(finalColor, 1.0f);
}
