#version 300 es
precision mediump float;
in vec2 v_texCoord0;
layout(location = 0) out vec4 outColor;

uniform sampler2D s_TextureSrc;
uniform sampler2D s_TextureDst;
uniform float u_alpha;


void main()
{
    vec4 ColorSrc = texture(s_TextureSrc, v_texCoord0);
    vec4 ColorDst = texture(s_TextureDst, v_texCoord0);

    // GLES20.glBlendFunc(GLES20.GL_ONE_MINUS_DST_COLOR, GLES20.GL_ONE);
    outColor.r = ColorSrc.r * (1.0f - ColorDst.r) + ColorDst.r;
    outColor.g = ColorSrc.g * (1.0f - ColorDst.g) + ColorDst.g;
    outColor.b = ColorSrc.b * (1.0f - ColorDst.b) + ColorDst.b;
    outColor.a = 1.0f;
    //outColor.a = u_alpha;
}

