#version 300 es
precision mediump float;
in vec2 v_texCoord0;
layout(location = 0) out vec4 outColor;
uniform sampler2D s_TextureMap;
uniform sampler2D s_BackgroundMap;
uniform sampler2D s_LutMap;
uniform vec2 u_resolution;
uniform vec2 u_TexSize;
uniform float u_stretch;
uniform float u_alpha;

void main()
{
    vec2 v_texCoord_cloud = vec2(v_texCoord0.x, v_texCoord0.y*u_resolution.y/u_resolution.x*u_TexSize.x/u_TexSize.y*u_stretch);
    vec4 cloud = vec4(0.0f);
    cloud = texture(s_TextureMap, v_texCoord_cloud);

    // use LUT for color and correction
    vec4 cloud_gray  = texture(s_TextureMap, v_texCoord_cloud);
    vec2 lutcoord = vec2(0.0f, cloud_gray.r);
    vec4 c_lut = texture(s_LutMap, lutcoord);
    cloud = vec4(c_lut.r, c_lut.g, c_lut.b, cloud_gray.g);
    float lightning = cloud_gray.b;

    // add lightning
    cloud.rgb += lightning*vec3(0.7f, 0.7f, 0.9f);

    vec4 ColorDst = texture(s_BackgroundMap, v_texCoord0); // background color
    outColor.rgb = cloud.rgb*cloud.a + ColorDst.rgb*(1.0f-cloud.a);
    outColor.a = u_alpha;
}