#version 300 es
precision mediump float;
in vec2 v_texCoord0;
layout(location = 0) out vec4 outColor;
uniform sampler2D s_TextureMapR;
uniform sampler2D s_TextureMapG;
uniform sampler2D s_TextureMapB;
uniform sampler2D s_BackgroundMap;
uniform float u_time;
uniform vec2 u_resolution;
uniform int u_frame_id;
uniform int NUM_ROW;
uniform int NUM_COL;
uniform int u_texWidth;
uniform int u_texHeight;
uniform float u_alpha;

float remap(float x, float a, float b, float c, float d)
{
    return (((x - a) / (b - a)) * (d - c)) + c;
}

float compute(float w, float x, float y, float z)
{
    return (w*x)/(y*z);
}
void main()
{
    int im_id = u_frame_id % int(NUM_ROW*NUM_COL);
    int offset_x = im_id%NUM_COL;
    int offset_y = im_id/NUM_COL;

    float x = v_texCoord0.x;
    float y = v_texCoord0.y*u_resolution.y/u_resolution.x*float(u_texWidth)/float(u_texHeight);

    y = clamp(y, 0.0f, 0.99f);
    // pixel coordinate
    int pixel_x= offset_x*u_texWidth + int(x*float(u_texWidth))+1;
    int pixel_y= offset_y*u_texHeight + int(y*float(u_texHeight))+1;// REMOVES white line

    // texture coordinate
    vec2 texCoord = vec2(float(pixel_x)/float(NUM_ROW*u_texWidth),
    float(pixel_y)/float(NUM_COL*u_texHeight));

    vec4 cloud_red  = texture(s_TextureMapR, texCoord);
    vec4 cloud_green = texture(s_TextureMapG, texCoord);
    vec4 cloud_blue = texture(s_TextureMapB, texCoord);
    float lightning = cloud_blue.a;
    vec4 cloud = vec4(cloud_red.a, cloud_red.a, cloud_red.a, cloud_green.a);
    // add lightning
    cloud.rgb += lightning*vec3(0.7f, 0.7f, 0.9f);

    vec4 ColorDst = texture(s_BackgroundMap, v_texCoord0);// background color
    outColor.rgb = cloud.rgb*cloud.a + ColorDst.rgb*(1.0f-cloud.a);
    outColor.a = u_alpha;
}