#version 300 es
precision mediump float;
in vec2 v_texCoord0;
layout(location = 0) out vec4 outColor;
uniform sampler2D s_TextureMap; // cloud texture， RG for frame 0, 2, 4, ...; BA for frame 1, 3, 5, ...
uniform sampler2D s_BackgroundMap;
uniform vec2 u_resolution;
uniform int u_frame_id;
uniform float z_scaleX; // zoom scale factor
uniform float z_scaleY;
uniform float z_beginX; // zoom begin coordinate
uniform float z_beginY;
uniform float u_alpha;

float BackgroundMask(float val)
{
    return 1.0f/(1.0f + exp(-10.0f*(val-1.0f)));
}

void main()
{
    float CloudTex_x = v_texCoord0.x * z_scaleX + z_beginX;
    float CloudTex_y = v_texCoord0.y * u_resolution.y/u_resolution.x*z_scaleY + z_beginY;
    vec2 v_texCoord_cloud = vec2(CloudTex_x, CloudTex_y);
    vec4 cloud = vec4(0.0f);
    float lightning = 0.0f;
    vec4 cloud_raw = texture(s_TextureMap, v_texCoord_cloud);

    // cloud color by even/odd frame
    cloud.rgb = cloud_raw.rrr*float((u_frame_id+1)%2) + cloud_raw.bbb*float(u_frame_id%2);
    lightning = cloud_raw.g*float((u_frame_id+1)%2) + cloud_raw.a*float(u_frame_id%2);

    // add lightning
    cloud.rgb += lightning*vec3(0.7f, 0.7f, 0.9f);

    vec4 ColorDst = texture(s_BackgroundMap, v_texCoord0); // background color
    outColor.rgb = cloud.rgb + ColorDst.rgb*BackgroundMask(v_texCoord0.y*u_resolution.y/u_resolution.x+z_beginY);
    outColor.rgb = clamp(outColor.rgb, 0.0f, 1.0f);
    outColor.a = u_alpha;
}