#version 310 es
#extension GL_EXT_gpu_shader5 : enable
precision highp float;

out vec4 outColor;

in vec4 v_fragmentColor;
in vec2 v_texCoord;

uniform int texIndex;
uniform sampler2D overcastMap[2];
uniform sampler2D noiseMap;
//uniform float resolutionY;
uniform float time;
uniform float maximum;
uniform float timeFactor;
uniform float resolution;

in float v_pointHeight;

void main()
{
	vec2 noiseCoord = vec2(v_texCoord.s + time * timeFactor, v_texCoord.t + time * timeFactor);
	vec4 displace = texture(noiseMap, noiseCoord);
	float displace_k  = displace.r * maximum;
	
	vec2 displaced = vec2(v_texCoord.x + displace_k, v_texCoord.y + displace_k);

	// 获取overcast的alpha：overcastMap的R、G或B通道值
	outColor = texture(overcastMap[texIndex/3], displaced);
	outColor.a = outColor[texIndex%3];

	// 获取overcast的alpha：overcastMap的R、G或B通道值
	outColor.a = smoothstep(0.0, 1.0, outColor.a);	// 平滑贴图边缘，防止露馅
	outColor.rgb = outColor.a > 0.0 ? vec3(1.0) : vec3(0.0);
	outColor.rgb *= outColor.a;
	outColor *= v_fragmentColor;

	mediump float whiteFactor = 1.0 - smoothstep(0.0, 1.0, v_pointHeight);
	whiteFactor += 0.60;
	outColor.rgb *= whiteFactor;
	outColor.rgb /= outColor.a;
}