#version 310 es
layout (location = 0) in vec4 position;

uniform mat4 u_projViewTrans;
uniform vec4 color;

out vec2 v_texCoord;
out float v_pointY;

out vec4 v_fragmentColor;
out float v_pointHeight;

void main()
{
    gl_Position =  u_projViewTrans * vec4(position.xy, 0.0, 1.0);

	v_fragmentColor = color;
	v_texCoord = position.zw;

	v_pointY = gl_Position.y / gl_Position.w;

	int i = gl_VertexID % 6;
	if (i == 0 || i == 3 || i == 5)
		v_pointHeight = 0.0;
	else
		v_pointHeight = 1.0;
}