#version 310 es
#extension GL_EXT_gpu_shader5 : enable
precision highp float;

out vec4 outColor;

in float v_sin;
in float v_cos;
in float v_texIndex;
in vec4 v_fragmentColor;

uniform sampler2D overcastMap[2];
uniform sampler2D noiseMap;
uniform float time;
uniform float maximum;
uniform float timeFactor;

void main()
{
	float x = gl_PointCoord.x - 0.5;
	float y = gl_PointCoord.y - 0.5;
	float nx = (v_cos * x - v_sin * y);
	float ny = (v_sin * x + v_cos * y);
	vec2 newCoord = vec2(nx + 0.5, ny + 0.5);

	vec2 noiseCoord = vec2(gl_PointCoord.s + time * timeFactor, gl_PointCoord.t + time * timeFactor);
	vec4 displace = texture(noiseMap, noiseCoord);
	float displace_k  = displace.r * maximum;

	newCoord = vec2(newCoord.x + displace_k, newCoord.y - displace_k);

	int index = int(v_texIndex);
	// 获取overcast的alpha：overcastMap的R、G或B通道值
	outColor = texture(overcastMap[index/3], newCoord);
	outColor.a = outColor[index%3];

	// 获取overcast的alpha：overcastMap的R、G或B通道值
	outColor.a = smoothstep(0.0, 1.0, outColor.a);	// 平滑贴图边缘，防止露馅
	outColor.rgb = outColor.a > 0.0 ? vec3(1.0) : vec3(0.0);
	outColor.rgb *= outColor.a;
	outColor *= v_fragmentColor;
//	outColor = texture(overcastMap[index], newCoord) * v_fragmentColor;

	outColor.rgb /= outColor.a;
}