#version 310 es
layout (location = 0) in vec2 position;
layout (location = 1) in vec4 color;
layout (location = 2) in vec4 attrib;

uniform mat4 u_projViewTrans;
uniform float u_pointSizeScale;

out float v_sin;
out float v_cos;
out vec4 v_fragmentColor;
out float texIndex;
out float scaleFactor;

void main()
{
    gl_PointSize = attrib.x / 4.0f * u_pointSizeScale;
    //gl_PointSize = attrib.x / 2.5f;
    gl_Position =  u_projViewTrans * vec4(position, 0.0, 1.0);

    v_sin = sin(attrib.y);
    v_cos = cos(attrib.y);
    texIndex = attrib.z;
    scaleFactor = attrib.w;
    v_fragmentColor = color;
}