#version 300 es

precision mediump float;

uniform sampler2D u_tex;
uniform float u_alpha;
uniform float u_pm;

in highp vec2 v_texCoord0;

out vec4 fragColor;

void main() {
    vec3 color = texture(u_tex, v_texCoord0).rgb;
    float finalAlhpa;
    if(u_pm < 100.0){
        finalAlhpa = 0.0;
    } else {
        finalAlhpa = (0.35 + smoothstep(100.0, 500.0, u_pm) * 0.4) * u_alpha;
    }
    fragColor = vec4(color, finalAlhpa);
}

