#version 300 es

precision lowp float;

uniform sampler2D u_tex[3];

uniform float u_finalAlpha;

in float v_type;
in float v_alpha;
in float v_angleCos;
in float v_angleSin;
in float v_discard;
in float v_random;

out vec4 fragColor;

vec2 particleRotate(){
    float x = gl_PointCoord.x - 0.5;
    float y = gl_PointCoord.y - 0.5;
    float nx = (v_angleCos * x - v_angleSin * y);
    float ny = (v_angleSin * x + v_angleCos * y);
    return vec2(nx + 0.5, ny + 0.5);
}

void main()    {
    if (v_discard > 0.1){
        discard;
    }

    vec4 color;

    vec2 coord = particleRotate();

    if (coord.x < 0.4 || coord.x > 0.6){
        discard;
    }

    coord.y *=(0.8+v_random*0.4);

    int type = int(v_type);

    if (type == 0){
        color = texture(u_tex[0], vec2(coord.x, coord.y));
    } else if (type == 1){
        color = texture(u_tex[1], vec2(coord.x, coord.y));
    } else if (type == 2){
        color = texture(u_tex[2], vec2(coord.x, coord.y));
    }

    if (color.a < 0.01){
        discard;
    }

    fragColor = vec4(vec3(1.0), color.a * u_finalAlpha * v_alpha * 0.7/*  *  gl_PointCoord.y*/);
}