#version 300 es

uniform mat4 u_projViewTrans;
uniform mat4 u_viewTrans;
uniform float u_time;
uniform float u_focalWidth;
uniform float u_focalDistance;
uniform float u_farClip;

in vec3 a_position;
in vec2 a_velocity;
in vec2 a_acc;
in float a_start;
in float a_size;
in float a_type;
in float a_random;

out float v_type;
out float v_height;
out float v_alpha;
out float v_angleCos;
out float v_angleSin;
out float v_discard;
out float v_random;

const vec2 UP = vec2(0.0, 1.0);

float getBlurFactor(float depth) {
    return smoothstep(0.0, u_focalWidth, abs(u_focalDistance - (depth * u_farClip)));
}

//使雨滴粒子方向跟随镜头转动
void processAngle(vec2 v, float t){
    vec2 dir = v + a_acc * t;
    vec4 pos1 = u_viewTrans * vec4(a_position, 1.0);
    vec4 pos2 = u_viewTrans * vec4(a_position + vec3(dir, 0), 1.0);
    vec4 screen_dir = pos2 - pos1;
    v_angleCos = dot(normalize(screen_dir.xy), UP);
    v_angleSin = sqrt(1.0 - v_angleCos * v_angleCos);
    if(screen_dir.x >= 0.){
        v_angleSin = -v_angleSin;
    }
}

void main()	{
    v_random = a_random;
    v_type = a_type;
    int type = int(a_type);

    float time = u_time - a_start;

    float zfactor = smoothstep(0.0, 0.4, 0.2 + a_position.z);

    vec2 velocity = a_velocity*(0.6 + zfactor * 0.8);

    //粒子转动
    processAngle(velocity, time);

    //粒子运动
    vec3 position = a_position + vec3(velocity, 0.0) * time + 0.5 * vec3(a_acc, 0.0) * time * time;
    gl_Position = u_projViewTrans * vec4(position, 1.0);

    vec3 positionVS = (u_viewTrans * vec4(position, 1.0)).xyz;
    float depth = -positionVS.z / u_farClip;

    float scale_size = a_size / 2.0;
    if(type == 0){
        float size = scale_size * (0.6 + 0.4 * a_random)*(0.6 + zfactor*0.6);
        gl_PointSize = size;
        v_alpha = smoothstep(0.0, 0.8, a_random) * (0.1 + 0.8*(1.0-getBlurFactor(depth)));
    } else if(type == 1){
        float size = scale_size * (0.6 + 0.4 * a_random)*(0.6 + zfactor*0.6);
        gl_PointSize = size;
        v_alpha = smoothstep(0.0, 0.8, a_random) * 0.2;
    } else if (type == 2){ // circle particles
        float size = scale_size * zfactor * a_random;
        gl_PointSize = size / 2.0;
        v_alpha = 25.0/size;
    } else {
        v_alpha = 0.2;
        gl_PointSize = scale_size*(0.6 + 0.4 * a_random)*(0.6+(1.0 - depth)*0.4);
    }

    if(type == 1){
        v_alpha *= 0.7;
    }

    v_discard = -1.0;
    float screenY = gl_Position.y/gl_Position.w;
    if(screenY < -0.18){
        v_discard = 1.0;
    }
    else if(screenY < 0.15){
        v_alpha *= (1.0 + (screenY - 0.15) * 3.0);
    }
}